/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentRefHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentWeakHashMap<K, V>
extends ConcurrentRefHashMap<K, V> {
    @Override
    protected ConcurrentRefHashMap.Key<K, V> createKey(@NotNull K key, V value, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentWeakHashMap", "createKey"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/containers/ConcurrentWeakHashMap", "createKey"));
        }
        return new WeakKey(key, hashingStrategy.computeHashCode(key), value, this.myReferenceQueue);
    }

    public ConcurrentWeakHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentWeakHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentWeakHashMap() {
    }

    public ConcurrentWeakHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/containers/ConcurrentWeakHashMap", "<init>"));
        }
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    public ConcurrentWeakHashMap(Map<? extends K, ? extends V> t) {
        super(t);
    }

    public ConcurrentWeakHashMap(@NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentWeakHashMap", "<init>"));
        }
        super(hashingStrategy);
    }

    private static class WeakKey<K, V>
    extends WeakReference<K>
    implements ConcurrentRefHashMap.Key<K, V> {
        private final int myHash;
        private final V value;

        private WeakKey(@NotNull K k, int hash, V v, ReferenceQueue<K> q) {
            if (k == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentWeakHashMap$WeakKey", "<init>"));
            }
            super(k, q);
            this.value = v;
            this.myHash = hash;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConcurrentRefHashMap.Key)) {
                return false;
            }
            Object t = this.get();
            Object u = ((ConcurrentRefHashMap.Key)o).get();
            if (t == null || u == null) {
                return false;
            }
            if (t == u) {
                return true;
            }
            return t.equals(u);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }
    }
}

