/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentRefHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ConcurrentSoftHashMap<K, V>
extends ConcurrentRefHashMap<K, V> {
    @Override
    protected ConcurrentRefHashMap.Key<K, V> createKey(@NotNull K key, V value, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentSoftHashMap", "createKey"));
        }
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/containers/ConcurrentSoftHashMap", "createKey"));
        }
        return new SoftKey(key, hashingStrategy.computeHashCode(key), value, this.myReferenceQueue);
    }

    public ConcurrentSoftHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentSoftHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentSoftHashMap() {
    }

    public ConcurrentSoftHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/containers/ConcurrentSoftHashMap", "<init>"));
        }
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    public ConcurrentSoftHashMap(Map<? extends K, ? extends V> t) {
        super(t);
    }

    public ConcurrentSoftHashMap(@NotNull TObjectHashingStrategy<K> hashingStrategy) {
        if (hashingStrategy == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentSoftHashMap", "<init>"));
        }
        super(hashingStrategy);
    }

    private static class SoftKey<K, V>
    extends SoftReference<K>
    implements ConcurrentRefHashMap.Key<K, V> {
        private final int myHash;
        private final V value;

        private SoftKey(@NotNull K k, int hash, V v, @NotNull ReferenceQueue<K> q) {
            if (k == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/containers/ConcurrentSoftHashMap$SoftKey", "<init>"));
            }
            if (q == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/util/containers/ConcurrentSoftHashMap$SoftKey", "<init>"));
            }
            super(k, q);
            this.value = v;
            this.myHash = hash;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            Object u;
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConcurrentRefHashMap.Key)) {
                return false;
            }
            Object t = this.get();
            if (t == (u = ((ConcurrentRefHashMap.Key)o).get())) {
                return true;
            }
            if (t == null || u == null) {
                return false;
            }
            return t.equals(u);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }
    }
}

