/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.StripedLockIntObjectConcurrentHashMap;
import java.lang.ref.ReferenceQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

abstract class ConcurrentRefValueIntObjectHashMap<V>
implements ConcurrentIntObjectMap<V> {
    private final StripedLockIntObjectConcurrentHashMap<IntReference<V>> myMap = new StripedLockIntObjectConcurrentHashMap();
    private final ReferenceQueue<V> myQueue = new ReferenceQueue();

    ConcurrentRefValueIntObjectHashMap() {
    }

    protected abstract IntReference<V> createReference(int var1, @NotNull V var2, ReferenceQueue<V> var3);

    private void processQueue() {
        IntReference ref;
        while ((ref = (IntReference)((Object)this.myQueue.poll())) != null) {
            int key = ref.getKey();
            this.myMap.remove(key, ref);
        }
        return;
    }

    @Override
    @NotNull
    public V cacheOrGet(int key, @NotNull V value) {
        IntReference<V> ref;
        boolean replaced;
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "cacheOrGet"));
        }
        this.processQueue();
        IntReference<V> newRef = this.createReference(key, value, this.myQueue);
        do {
            if ((ref = this.myMap.putIfAbsent(key, newRef)) == null) {
                V v = value;
                if (v == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "cacheOrGet"));
                }
                return v;
            }
            V old = ref.get();
            if (old == null) continue;
            V v = old;
            if (v == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "cacheOrGet"));
            }
            return v;
        } while (!(replaced = this.myMap.replace(key, ref, newRef)));
        V v = value;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "cacheOrGet"));
        }
        return v;
    }

    @Override
    public boolean remove(int key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "remove"));
        }
        this.processQueue();
        return this.myMap.remove(key, this.createReference(key, value, this.myQueue));
    }

    @Override
    public boolean replace(int key, @NotNull V oldValue, @NotNull V newValue) {
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "replace"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "replace"));
        }
        this.processQueue();
        return this.myMap.replace(key, this.createReference(key, oldValue, this.myQueue), this.createReference(key, newValue, this.myQueue));
    }

    @Override
    public V put(int key, @NotNull V value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "put"));
        }
        this.processQueue();
        IntReference<V> ref = this.myMap.put(key, this.createReference(key, value, this.myQueue));
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V get(int key) {
        IntReference<V> ref = this.myMap.get(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public V remove(int key) {
        this.processQueue();
        IntReference<V> ref = this.myMap.remove(key);
        return ref == null ? null : (V)ref.get();
    }

    @Override
    public boolean containsKey(int key) {
        return this.myMap.containsKey(key);
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @Override
    @NotNull
    public int[] keys() {
        int[] nArray = this.myMap.keys();
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "keys"));
        }
        return nArray;
    }

    @Override
    @NotNull
    public Iterable<StripedLockIntObjectConcurrentHashMap.IntEntry<V>> entries() {
        final Iterator<StripedLockIntObjectConcurrentHashMap.IntEntry<IntReference<V>>> entryIterator = this.myMap.entries().iterator();
        Iterable iterable = new Iterable<StripedLockIntObjectConcurrentHashMap.IntEntry<V>>(){

            @Override
            public Iterator<StripedLockIntObjectConcurrentHashMap.IntEntry<V>> iterator() {
                return new Iterator<StripedLockIntObjectConcurrentHashMap.IntEntry<V>>(){
                    StripedLockIntObjectConcurrentHashMap.IntEntry<V> next = this.nextAliveEntry();

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public StripedLockIntObjectConcurrentHashMap.IntEntry<V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        StripedLockIntObjectConcurrentHashMap.IntEntry result = this.next;
                        this.next = this.nextAliveEntry();
                        return result;
                    }

                    private StripedLockIntObjectConcurrentHashMap.IntEntry<V> nextAliveEntry() {
                        while (entryIterator.hasNext()) {
                            StripedLockIntObjectConcurrentHashMap.IntEntry entry = (StripedLockIntObjectConcurrentHashMap.IntEntry)entryIterator.next();
                            final Object v = ((IntReference)entry.getValue()).get();
                            if (v == null) continue;
                            final int key = entry.getKey();
                            return new StripedLockIntObjectConcurrentHashMap.IntEntry<V>(){

                                @Override
                                public int getKey() {
                                    return key;
                                }

                                @Override
                                @NotNull
                                public V getValue() {
                                    Object object = v;
                                    if (object == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap$1$1$1", "getValue"));
                                    }
                                    return object;
                                }
                            };
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new IncorrectOperationException("not implemented");
                    }
                };
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/containers/ConcurrentRefValueIntObjectHashMap", "entries"));
        }
        return iterable;
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    protected static interface IntReference<V> {
        public int getKey();

        public V get();
    }
}

