/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;

public class ClassMap<T> {
    protected final Map<Class, T> myMap;

    public ClassMap() {
        this((Map<Class, T>)new THashMap());
    }

    protected ClassMap(Map<Class, T> map) {
        this.myMap = map;
    }

    public void put(Class aClass, T value) {
        this.myMap.put(aClass, value);
    }

    public void remove(Class aClass) {
        this.myMap.remove(aClass);
    }

    public T get(Class aClass) {
        T t = this.myMap.get(aClass);
        if (t != null) {
            return t;
        }
        for (Class<?> aClass1 : aClass.getInterfaces()) {
            t = this.get(aClass1);
            if (t == null) continue;
            this.myMap.put(aClass, t);
            return t;
        }
        Class superclass = aClass.getSuperclass();
        if (superclass != null && (t = this.get(superclass)) != null) {
            this.myMap.put(aClass, t);
            return t;
        }
        return null;
    }

    public final Collection<T> values() {
        return this.myMap.values();
    }

    public void clear() {
        this.myMap.clear();
    }
}

