/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundedTaskExecutor
implements Executor {
    protected final Executor myBackendExecutor;
    private final int myMaxTasks;
    private final AtomicInteger myInProgress = new AtomicInteger(0);
    private final Queue<FutureTask> myTaskQueue = new LinkedBlockingQueue<FutureTask>();
    private final Runnable USER_TASK_RUNNER = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FutureTask task = (FutureTask)BoundedTaskExecutor.this.myTaskQueue.poll();
            try {
                if (task != null && !task.isCancelled()) {
                    task.run();
                }
            }
            finally {
                BoundedTaskExecutor.this.myInProgress.decrementAndGet();
                if (!BoundedTaskExecutor.this.myTaskQueue.isEmpty()) {
                    BoundedTaskExecutor.this.processQueue();
                }
            }
        }
    };

    public BoundedTaskExecutor(Executor backendExecutor, int maxSimultaneousTasks) {
        this.myBackendExecutor = backendExecutor;
        this.myMaxTasks = Math.max(maxSimultaneousTasks, 1);
    }

    @Override
    public void execute(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/concurrency/BoundedTaskExecutor", "execute"));
        }
        this.submit(task);
    }

    public Future<?> submit(Runnable task) {
        RunnableFuture<Object> future = this.queueTask(new FutureTask<Object>(task, null));
        if (future == null) {
            throw new RuntimeException("Failed to queue task: " + task);
        }
        return future;
    }

    public <T> Future<T> submit(Callable<T> task) {
        RunnableFuture<T> future = this.queueTask(new FutureTask<T>(task));
        if (future == null) {
            throw new RuntimeException("Failed to queue task: " + task);
        }
        return future;
    }

    @Nullable
    private <T> RunnableFuture<T> queueTask(FutureTask<T> futureTask) {
        if (this.myTaskQueue.offer(futureTask)) {
            this.processQueue();
            return futureTask;
        }
        return null;
    }

    protected void processQueue() {
        int count;
        do {
            if ((count = this.myInProgress.get()) < this.myMaxTasks) continue;
            return;
        } while (!this.myInProgress.compareAndSet(count, count + 1));
        this.myBackendExecutor.execute(this.USER_TASK_RUNNER);
    }
}

