/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedProcessingContext {
    private final Map<Object, Object> myMap = ContainerUtil.newConcurrentMap();

    public Object get(@NotNull @NonNls String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/SharedProcessingContext", "get"));
        }
        return this.myMap.get(key);
    }

    public void put(@NotNull @NonNls String key, @NotNull Object value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/SharedProcessingContext", "put"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/SharedProcessingContext", "put"));
        }
        this.myMap.put(key, value);
    }

    public <T> void put(Key<T> key, T value) {
        this.myMap.put(key, value);
    }

    public <T> T get(Key<T> key) {
        return (T)this.myMap.get(key);
    }

    @Nullable
    public <T> T get(@NotNull Key<T> key, Object element) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/SharedProcessingContext", "get"));
        }
        Map map = (Map)this.myMap.get(key);
        if (map == null) {
            return null;
        }
        return (T)map.get(element);
    }

    public <T> void put(@NotNull Key<T> key, Object element, T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/SharedProcessingContext", "put"));
        }
        Map map = (Map)this.myMap.get(key);
        if (map == null) {
            map = new THashMap();
            this.myMap.put(key, map);
        }
        map.put(element, value);
    }
}

