/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ResourceUtil {
    @NonNls
    private static final String ENCODING_UTF_8 = "UTF-8";

    private ResourceUtil() {
    }

    public static URL getResource(@NotNull Class loaderClass, @NonNls @NotNull String basePath, @NonNls @NotNull String fileName) {
        if (loaderClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ResourceUtil", "getResource"));
        }
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ResourceUtil", "getResource"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/ResourceUtil", "getResource"));
        }
        return ResourceUtil.getResource(loaderClass.getClassLoader(), basePath, fileName);
    }

    public static URL getResource(@NotNull ClassLoader loader, @NonNls @NotNull String basePath, @NonNls @NotNull String fileName) {
        if (loader == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ResourceUtil", "getResource"));
        }
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ResourceUtil", "getResource"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/util/ResourceUtil", "getResource"));
        }
        String fixedPath = StringUtil.trimStart(StringUtil.trimEnd(basePath, "/"), "/");
        List<String> bundles = ResourceUtil.calculateBundleNames(fixedPath, Locale.getDefault());
        for (String bundle : bundles) {
            URL url = loader.getResource(bundle + "/" + fileName);
            if (url == null) continue;
            try {
                url.openConnection();
            }
            catch (IOException e) {
                continue;
            }
            return url;
        }
        return loader.getResource(fixedPath + "/" + fileName);
    }

    private static List<String> calculateBundleNames(String baseName, Locale locale) {
        ArrayList<String> result = new ArrayList<String>(3);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        result.add(0, baseName);
        if (languageLength + countryLength + variantLength == 0) {
            return result;
        }
        StringBuilder temp = new StringBuilder(baseName);
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.add(0, temp.toString());
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.add(0, temp.toString());
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.add(0, temp.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static String loadText(@NotNull URL url) throws IOException {
        int length;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ResourceUtil", "loadText"));
        }
        BufferedInputStream inputStream = new BufferedInputStream(URLUtil.openStream(url));
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, ENCODING_UTF_8);
        StringBuilder text = new StringBuilder();
        char[] buf = new char[5000];
        while (reader.ready() && (length = reader.read(buf)) != -1) {
            text.append(buf, 0, length);
        }
        String string = text.toString();
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ResourceUtil", "loadText"));
        }
        return string2;
        finally {
            reader.close();
        }
    }
}

