/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.NotNull;

public class FunctionUtil {
    private FunctionUtil() {
    }

    @NotNull
    public static <T> Function<T, T> id() {
        Function id;
        Function function = id = Function.ID;
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FunctionUtil", "id"));
        }
        return function;
    }

    @NotNull
    public static <A, B> NullableFunction<A, B> nullConstant() {
        NullableFunction function;
        NullableFunction nullableFunction = function = NullableFunction.NULL;
        if (nullableFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FunctionUtil", "nullConstant"));
        }
        return nullableFunction;
    }

    @NotNull
    public static <T> Function<T, String> string() {
        Function function;
        Function function2 = function = Function.TO_STRING;
        if (function2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FunctionUtil", "string"));
        }
        return function2;
    }

    @NotNull
    public static <A, B> Function<A, B> constant(final B b) {
        Function function = new Function<A, B>(){

            @Override
            public B fun(A a) {
                return b;
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FunctionUtil", "constant"));
        }
        return function;
    }

    @NotNull
    public static <A, B, C> NotNullFunction<A, C> composition(final @NotNull NotNullFunction<B, C> f, final @NotNull NotNullFunction<A, B> g) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/FunctionUtil", "composition"));
        }
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/FunctionUtil", "composition"));
        }
        NotNullFunction notNullFunction = new NotNullFunction<A, C>(){

            @Override
            @NotNull
            public C fun(A a) {
                Object Result = f.fun(g.fun(a));
                if (Result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FunctionUtil$2", "fun"));
                }
                return Result;
            }
        };
        if (notNullFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/FunctionUtil", "composition"));
        }
        return notNullFunction;
    }
}

