/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CollectConsumer<T>
implements Consumer<T> {
    private final Collection<T> myResult;

    public CollectConsumer(@NotNull Collection<T> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/CollectConsumer", "<init>"));
        }
        this.myResult = result;
    }

    public CollectConsumer() {
        this(new SmartList());
    }

    @Override
    public void consume(T t) {
        this.myResult.add(t);
    }

    @NotNull
    public Collection<T> getResult() {
        Collection<T> collection = this.myResult;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CollectConsumer", "getResult"));
        }
        return collection;
    }
}

