/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableUtil {
    private TableUtil() {
    }

    @NotNull
    public static List<Object[]> removeSelectedItems(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TableUtil", "removeSelectedItems"));
        }
        List<Object[]> list = TableUtil.removeSelectedItems(table, null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TableUtil", "removeSelectedItems"));
        }
        return list;
    }

    public static void selectRows(@NotNull JTable table, @NotNull int[] viewRows) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TableUtil", "selectRows"));
        }
        if (viewRows == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/TableUtil", "selectRows"));
        }
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.clearSelection();
        int count = table.getRowCount();
        for (int row : viewRows) {
            if (row < 0 || row >= count) continue;
            selectionModel.addSelectionInterval(row, row);
        }
    }

    public static void scrollSelectionToVisible(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TableUtil", "scrollSelectionToVisible"));
        }
        ListSelectionModel selectionModel = table.getSelectionModel();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        int maxColumnSelectionIndex = Math.max(0, table.getColumnModel().getSelectionModel().getMinSelectionIndex());
        int minColumnSelectionIndex = Math.max(0, table.getColumnModel().getSelectionModel().getMaxSelectionIndex());
        if (maxSelectionIndex == -1) {
            return;
        }
        Rectangle minCellRect = table.getCellRect(minSelectionIndex, minColumnSelectionIndex, false);
        Rectangle maxCellRect = table.getCellRect(maxSelectionIndex, maxColumnSelectionIndex, false);
        Point selectPoint = minCellRect.getLocation();
        int allHeight = maxCellRect.y + maxCellRect.height - minCellRect.y;
        allHeight = Math.min(allHeight, table.getVisibleRect().height);
        table.scrollRectToVisible(new Rectangle(selectPoint, new Dimension(minCellRect.width / 2, allHeight)));
    }

    @NotNull
    public static List<Object[]> removeSelectedItems(@NotNull JTable table, @Nullable ItemChecker applyable) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TableUtil", "removeSelectedItems"));
        }
        final TableModel model = table.getModel();
        if (!(model instanceof ItemRemovable)) {
            throw new RuntimeException("model must be instance of ItemRemovable");
        }
        if (table.getSelectionModel().isSelectionEmpty()) {
            ArrayList<Object[]> arrayList = new ArrayList<Object[]>(0);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TableUtil", "removeSelectedItems"));
            }
            return arrayList;
        }
        final SmartList removedItems = new SmartList();
        final ItemRemovable itemRemovable = (ItemRemovable)((Object)model);
        final int columnCount = model.getColumnCount();
        TableUtil.doRemoveSelectedItems(table, new ItemRemovable(){

            @Override
            public void removeRow(int index) {
                Object[] row = new Object[columnCount];
                for (int column = 0; column < columnCount; ++column) {
                    row[column] = model.getValueAt(index, column);
                }
                removedItems.add(row);
                itemRemovable.removeRow(index);
            }
        }, applyable);
        List<Object[]> list = ContainerUtil.reverse(removedItems);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TableUtil", "removeSelectedItems"));
        }
        return list;
    }

    public static boolean doRemoveSelectedItems(@NotNull JTable table, @NotNull ItemRemovable itemRemovable, @Nullable ItemChecker applyable) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TableUtil", "doRemoveSelectedItems"));
        }
        if (itemRemovable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/ui/TableUtil", "doRemoveSelectedItems"));
        }
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
        ListSelectionModel selectionModel = table.getSelectionModel();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        if (minSelectionIndex == -1 || maxSelectionIndex == -1) {
            return false;
        }
        TableModel model = table.getModel();
        boolean removed = false;
        for (int index = maxSelectionIndex; index >= 0; --index) {
            if (!selectionModel.isSelectedIndex(index) || applyable != null && !applyable.isOperationApplyable(model, index)) continue;
            itemRemovable.removeRow(index);
            removed = true;
        }
        if (!removed) {
            return false;
        }
        int count = model.getRowCount();
        if (count == 0) {
            table.clearSelection();
        } else if (selectionModel.getMinSelectionIndex() == -1) {
            if (minSelectionIndex >= model.getRowCount()) {
                selectionModel.setSelectionInterval(model.getRowCount() - 1, model.getRowCount() - 1);
            } else {
                selectionModel.setSelectionInterval(minSelectionIndex, minSelectionIndex);
            }
        }
        return true;
    }

    public static int moveSelectedItemsUp(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TableUtil", "moveSelectedItemsUp"));
        }
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
        TableModel model = table.getModel();
        ListSelectionModel selectionModel = table.getSelectionModel();
        int counter = 0;
        for (int row = 0; row < model.getRowCount(); ++row) {
            if (!selectionModel.isSelectedIndex(row)) continue;
            ++counter;
            for (int column = 0; column < model.getColumnCount(); ++column) {
                Object temp = model.getValueAt(row, column);
                model.setValueAt(model.getValueAt(row - 1, column), row, column);
                model.setValueAt(temp, row - 1, column);
            }
            selectionModel.removeSelectionInterval(row, row);
            selectionModel.addSelectionInterval(row - 1, row - 1);
        }
        Rectangle cellRect = table.getCellRect(selectionModel.getMinSelectionIndex(), 0, true);
        if (cellRect != null) {
            table.scrollRectToVisible(cellRect);
        }
        table.repaint();
        return counter;
    }

    public static int moveSelectedItemsDown(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TableUtil", "moveSelectedItemsDown"));
        }
        if (table.isEditing()) {
            table.getCellEditor().stopCellEditing();
        }
        TableModel model = table.getModel();
        ListSelectionModel selectionModel = table.getSelectionModel();
        int counter = 0;
        for (int row = model.getRowCount() - 1; row >= 0; --row) {
            if (!selectionModel.isSelectedIndex(row)) continue;
            ++counter;
            for (int column = 0; column < model.getColumnCount(); ++column) {
                Object temp = model.getValueAt(row, column);
                model.setValueAt(model.getValueAt(row + 1, column), row, column);
                model.setValueAt(temp, row + 1, column);
            }
            selectionModel.removeSelectionInterval(row, row);
            selectionModel.addSelectionInterval(row + 1, row + 1);
        }
        Rectangle cellRect = table.getCellRect(selectionModel.getMaxSelectionIndex(), 0, true);
        if (cellRect != null) {
            table.scrollRectToVisible(cellRect);
        }
        table.repaint();
        return counter;
    }

    public static void editCellAt(@NotNull JTable table, int row, int column) {
        Component component;
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TableUtil", "editCellAt"));
        }
        if (table.editCellAt(row, column) && (component = table.getEditorComponent()) != null) {
            component.requestFocus();
        }
    }

    public static void stopEditing(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TableUtil", "stopEditing"));
        }
        if (table.isEditing()) {
            TableCellEditor editor;
            TableCellEditor cellEditor = table.getCellEditor();
            if (cellEditor != null) {
                cellEditor.stopCellEditing();
            }
            int row = table.getSelectedRow();
            int column = table.getSelectedColumn();
            if (row >= 0 && column >= 0 && (editor = table.getCellEditor(row, column)) != null) {
                editor.stopCellEditing();
            }
        }
    }

    public static void ensureSelectionExists(@NotNull JTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TableUtil", "ensureSelectionExists"));
        }
        if (table.getSelectedRow() != -1 || table.getRowCount() == 0) {
            return;
        }
        table.setRowSelectionInterval(0, 0);
    }

    public static void setupCheckboxColumn(@NotNull JTable table, int columnIndex) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TableUtil", "setupCheckboxColumn"));
        }
        TableUtil.setupCheckboxColumn(table.getColumnModel().getColumn(columnIndex));
    }

    public static void setupCheckboxColumn(@NotNull TableColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TableUtil", "setupCheckboxColumn"));
        }
        int checkboxWidth = new JCheckBox().getPreferredSize().width;
        column.setResizable(false);
        column.setPreferredWidth(checkboxWidth);
        column.setMaxWidth(checkboxWidth);
        column.setMinWidth(checkboxWidth);
    }

    public static void updateScroller(@NotNull JTable table, boolean temporaryHideVerticalScrollBar) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/ui/TableUtil", "updateScroller"));
        }
        JScrollPane scrollPane = UIUtil.getParentOfType(JScrollPane.class, table);
        if (scrollPane != null) {
            JScrollBar bar;
            if (temporaryHideVerticalScrollBar && ((bar = scrollPane.getVerticalScrollBar()) == null || !bar.isVisible())) {
                scrollPane.setVerticalScrollBarPolicy(21);
            }
            scrollPane.revalidate();
            scrollPane.repaint();
        }
    }

    public static interface ItemChecker {
        public boolean isOperationApplyable(@NotNull TableModel var1, int var2);
    }
}

