/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.DarculaColors;
import com.intellij.ui.Gray;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class JBColor
extends Color {
    private static volatile boolean DARK = UIUtil.isUnderDarcula();
    private final Color darkColor;
    public static final JBColor red;
    public static final JBColor RED;
    public static final JBColor blue;
    public static final JBColor BLUE;
    public static final JBColor white;
    public static final JBColor WHITE;
    public static final JBColor black;
    public static final JBColor BLACK;
    public static final JBColor gray;
    public static final JBColor GRAY;
    public static final JBColor lightGray;
    public static final JBColor LIGHT_GRAY;
    public static final JBColor darkGray;
    public static final JBColor DARK_GRAY;
    public static final JBColor pink;
    public static final JBColor PINK;
    public static final JBColor orange;
    public static final JBColor ORANGE;
    public static final JBColor yellow;
    public static final JBColor YELLOW;
    public static final JBColor green;
    public static final JBColor GREEN;
    public static final Color magenta;
    public static final Color MAGENTA;
    public static final Color cyan;
    public static final Color CYAN;

    public JBColor(int rgb, int darkRGB) {
        this(new Color(rgb), new Color(darkRGB));
    }

    public JBColor(Color regular, Color dark) {
        super(regular.getRGB(), regular.getAlpha() != 255);
        this.darkColor = dark;
        DARK = UIUtil.isUnderDarcula();
    }

    public static void setDark(boolean dark) {
        DARK = dark;
    }

    Color getDarkVariant() {
        return this.darkColor;
    }

    @Override
    public int getRed() {
        return DARK ? this.getDarkVariant().getRed() : super.getRed();
    }

    @Override
    public int getGreen() {
        return DARK ? this.getDarkVariant().getGreen() : super.getGreen();
    }

    @Override
    public int getBlue() {
        return DARK ? this.getDarkVariant().getBlue() : super.getBlue();
    }

    @Override
    public int getAlpha() {
        return DARK ? this.getDarkVariant().getAlpha() : super.getAlpha();
    }

    @Override
    public int getRGB() {
        return DARK ? this.getDarkVariant().getRGB() : super.getRGB();
    }

    @Override
    public Color brighter() {
        return new JBColor(super.brighter(), this.getDarkVariant().brighter());
    }

    @Override
    public Color darker() {
        return new JBColor(super.darker(), this.getDarkVariant().darker());
    }

    @Override
    public int hashCode() {
        return DARK ? this.getDarkVariant().hashCode() : super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return DARK ? this.getDarkVariant().equals(obj) : super.equals(obj);
    }

    @Override
    public String toString() {
        return DARK ? this.getDarkVariant().toString() : super.toString();
    }

    @Override
    public float[] getRGBComponents(float[] compArray) {
        return DARK ? this.getDarkVariant().getRGBComponents(compArray) : super.getRGBComponents(compArray);
    }

    @Override
    public float[] getRGBColorComponents(float[] compArray) {
        return DARK ? this.getDarkVariant().getRGBColorComponents(compArray) : super.getRGBComponents(compArray);
    }

    @Override
    public float[] getComponents(float[] compArray) {
        return DARK ? this.getDarkVariant().getComponents(compArray) : super.getComponents(compArray);
    }

    @Override
    public float[] getColorComponents(float[] compArray) {
        return DARK ? this.getDarkVariant().getColorComponents(compArray) : super.getColorComponents(compArray);
    }

    @Override
    public float[] getComponents(ColorSpace cspace, float[] compArray) {
        return DARK ? this.getDarkVariant().getComponents(cspace, compArray) : super.getComponents(cspace, compArray);
    }

    @Override
    public float[] getColorComponents(ColorSpace cspace, float[] compArray) {
        return DARK ? this.getDarkVariant().getColorComponents(cspace, compArray) : super.getColorComponents(cspace, compArray);
    }

    @Override
    public ColorSpace getColorSpace() {
        return DARK ? this.getDarkVariant().getColorSpace() : super.getColorSpace();
    }

    @Override
    public synchronized PaintContext createContext(ColorModel cm, Rectangle r, Rectangle2D r2d, AffineTransform xform, RenderingHints hints) {
        return DARK ? this.getDarkVariant().createContext(cm, r, r2d, xform, hints) : super.createContext(cm, r, r2d, xform, hints);
    }

    @Override
    public int getTransparency() {
        return DARK ? this.getDarkVariant().getTransparency() : super.getTransparency();
    }

    public static Color foreground() {
        return UIUtil.getLabelForeground();
    }

    public static Color background() {
        return UIUtil.getListBackground();
    }

    static {
        RED = red = new JBColor(Color.red, DarculaColors.RED);
        BLUE = blue = new JBColor(Color.blue, DarculaColors.BLUE);
        WHITE = white = new JBColor(Color.white, UIUtil.getListBackground()){

            @Override
            Color getDarkVariant() {
                return UIUtil.getListBackground();
            }
        };
        BLACK = black = new JBColor(Color.black, UIUtil.getListForeground()){

            @Override
            Color getDarkVariant() {
                return UIUtil.getListForeground();
            }
        };
        GRAY = gray = new JBColor(Gray._128, Gray._128);
        LIGHT_GRAY = lightGray = new JBColor(Gray._192, Gray._64);
        DARK_GRAY = darkGray = new JBColor(Gray._64, Gray._192);
        PINK = pink = new JBColor(Color.pink, Color.pink);
        ORANGE = orange = new JBColor(Color.orange, new Color(159, 107, 0));
        YELLOW = yellow = new JBColor(Color.yellow, new Color(138, 138, 0));
        GREEN = green = new JBColor(Color.green, new Color(98, 150, 85));
        MAGENTA = magenta = new JBColor(Color.magenta, new Color(151, 118, 169));
        CYAN = cyan = new JBColor(Color.cyan, new Color(0, 137, 137));
    }
}

