/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowsRegistryUtil {
    private WindowsRegistryUtil() {
    }

    @Nullable
    private static String trimToValue(@Nullable StringBuilder output) {
        if (output == null) {
            return null;
        }
        int pos = output.lastIndexOf("  ");
        int pos2 = output.lastIndexOf("\t");
        if ((pos = Math.max(pos, pos2)) == -1) {
            return null;
        }
        output.delete(0, pos + 1);
        String blackList = "\r\n \"";
        int startPos = 0;
        int endPos = output.length() - 1;
        while (true) {
            if (startPos >= endPos) {
                return null;
            }
            if (blackList.indexOf(output.charAt(startPos)) == -1) break;
            ++startPos;
        }
        while (blackList.indexOf(output.charAt(endPos)) != -1) {
            --endPos;
        }
        return ((Object)output.subSequence(startPos, endPos + 1)).toString();
    }

    @NotNull
    public static List<String> readRegistryBranch(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/io/WindowsRegistryUtil", "readRegistryBranch"));
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder output = WindowsRegistryUtil.readRegistry("reg query \"" + location + "\" /s");
        if (output != null) {
            int pos = output.indexOf(location);
            while (pos != -1) {
                String section;
                int pos2 = output.indexOf("\r\n", pos + location.length());
                if (pos2 > pos + location.length() && !(section = output.substring(pos + location.length() + 1, pos2)).contains("\\")) {
                    result.add(section);
                }
                pos = output.indexOf(location, pos + location.length());
            }
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/io/WindowsRegistryUtil", "readRegistryBranch"));
        }
        return arrayList;
    }

    @Nullable
    public static String readRegistryDefault(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/io/WindowsRegistryUtil", "readRegistryDefault"));
        }
        return WindowsRegistryUtil.trimToValue(WindowsRegistryUtil.readRegistry("reg query \"" + location + "\" /ve"));
    }

    @Nullable
    public static String readRegistryValue(@NotNull String location, @NotNull String key) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/util/io/WindowsRegistryUtil", "readRegistryValue"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/io/WindowsRegistryUtil", "readRegistryValue"));
        }
        return WindowsRegistryUtil.trimToValue(WindowsRegistryUtil.readRegistry("reg query \"" + location + "\" /v " + key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static StringBuilder readRegistry(String command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            StringBuilder output = null;
            InputStream is = null;
            ByteArrayOutputStream os = null;
            try {
                byte[] buffer = new byte[128];
                is = process.getInputStream();
                os = new ByteArrayOutputStream();
                int length = is.read(buffer);
                while (length > 0) {
                    os.write(buffer, 0, length);
                    length = is.read(buffer);
                }
                output = new StringBuilder(new String(os.toByteArray()));
            }
            catch (IOException ignored) {
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                process.waitFor();
            }
            return output;
        }
        catch (Exception e) {
            return null;
        }
    }
}

