/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiValuesMap<K, V> {
    private final Map<K, Collection<V>> myBaseMap;
    private final boolean myOrdered;

    public MultiValuesMap() {
        this(false);
    }

    public MultiValuesMap(boolean ordered) {
        this.myOrdered = ordered;
        this.myBaseMap = ordered ? new LinkedHashMap() : new HashMap();
    }

    public void putAll(K key, @NotNull Collection<V> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/MultiValuesMap", "putAll"));
        }
        for (V value : values) {
            this.put(key, value);
        }
    }

    public void putAll(K key, V ... values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/util/MultiValuesMap", "putAll"));
        }
        for (V value : values) {
            this.put(key, value);
        }
    }

    public void put(K key, V value) {
        Collection<V> collection = this.myBaseMap.get(key);
        if (collection == null) {
            collection = this.myOrdered ? new LinkedHashSet() : new HashSet();
            this.myBaseMap.put(key, collection);
        }
        collection.add(value);
    }

    public Collection<V> get(K key) {
        return this.myBaseMap.get(key);
    }

    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myBaseMap.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/MultiValuesMap", "keySet"));
        }
        return set;
    }

    @NotNull
    public Collection<V> values() {
        HashSet result = this.myOrdered ? new LinkedHashSet() : new HashSet();
        for (Collection<V> values : this.myBaseMap.values()) {
            result.addAll(values);
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/MultiValuesMap", "values"));
        }
        return hashSet;
    }

    public void remove(K key, V value) {
        if (!this.myBaseMap.containsKey(key)) {
            return;
        }
        Collection<V> values = this.myBaseMap.get(key);
        values.remove(value);
        if (values.isEmpty()) {
            this.myBaseMap.remove(key);
        }
    }

    public void clear() {
        this.myBaseMap.clear();
    }

    @Nullable
    public Collection<V> removeAll(K key) {
        return this.myBaseMap.remove(key);
    }

    @NotNull
    public Set<Map.Entry<K, Collection<V>>> entrySet() {
        Set<Map.Entry<K, Collection<V>>> set = this.myBaseMap.entrySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/MultiValuesMap", "entrySet"));
        }
        return set;
    }

    public boolean isEmpty() {
        return this.myBaseMap.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.myBaseMap.containsKey(key);
    }

    @NotNull
    public Collection<V> collectValues() {
        HashSet<V> result = new HashSet<V>();
        for (Collection<V> v : this.myBaseMap.values()) {
            result.addAll(v);
        }
        HashSet<V> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/MultiValuesMap", "collectValues"));
        }
        return hashSet;
    }

    @Nullable
    public V getFirst(K key) {
        Collection<V> values = this.myBaseMap.get(key);
        return values == null || values.isEmpty() ? null : (V)values.iterator().next();
    }
}

