/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.string;

import com.intellij.openapi.diff.impl.string.DiffString;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class DiffStringBuilder
implements CharSequence {
    @NotNull
    private char[] myData;
    private int myLength;

    public DiffStringBuilder() {
        this(16);
    }

    public DiffStringBuilder(int len) {
        this.myData = new char[len];
        this.myLength = 0;
    }

    @Override
    public int length() {
        return this.myLength;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.myLength) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.myData[index];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        DiffString.checkBounds(start, end, this.myLength);
        DiffString diffString = DiffString.create(this.myData, start, end - start);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffStringBuilder", "subSequence"));
        }
        return diffString;
    }

    @NotNull
    public DiffString toDiffString() {
        DiffString diffString = DiffString.create(this.myData, 0, this.myLength);
        if (diffString == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffStringBuilder", "toDiffString"));
        }
        return diffString;
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.toDiffString().toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/string/DiffStringBuilder", "toString"));
        }
        return string;
    }

    private void ensureCapacityInternal(int neededCapacity) {
        if (neededCapacity > this.myData.length) {
            int newCapacity;
            for (newCapacity = this.myData.length; newCapacity < neededCapacity; newCapacity *= 2) {
            }
            this.myData = Arrays.copyOf(this.myData, newCapacity);
        }
    }

    public void append(@NotNull DiffString s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/diff/impl/string/DiffStringBuilder", "append"));
        }
        if (s.isEmpty()) {
            return;
        }
        this.ensureCapacityInternal(this.myLength + s.length());
        s.copyData(this.myData, this.myLength);
        this.myLength += s.length();
    }
}

