/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch;

import com.intellij.openapi.diff.impl.patch.PatchLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PatchHunk {
    private final int myStartLineBefore;
    private final int myEndLineBefore;
    private final int myStartLineAfter;
    private final int myEndLineAfter;
    private final List<PatchLine> myLines = new ArrayList<PatchLine>();

    public PatchHunk(int startLineBefore, int endLineBefore, int startLineAfter, int endLineAfter) {
        this.myStartLineBefore = startLineBefore;
        this.myEndLineBefore = endLineBefore;
        this.myStartLineAfter = startLineAfter;
        this.myEndLineAfter = endLineAfter;
    }

    public int getStartLineBefore() {
        return this.myStartLineBefore;
    }

    public int getEndLineBefore() {
        return this.myEndLineBefore;
    }

    public int getStartLineAfter() {
        return this.myStartLineAfter;
    }

    public int getEndLineAfter() {
        return this.myEndLineAfter;
    }

    public void addLine(PatchLine line) {
        this.myLines.add(line);
    }

    public List<PatchLine> getLines() {
        return Collections.unmodifiableList(this.myLines);
    }

    public boolean isNewContent() {
        return this.myStartLineBefore == -1 && this.myEndLineBefore == -1;
    }

    public boolean isDeletedContent() {
        return this.myStartLineAfter == -1 && this.myEndLineAfter == -1;
    }

    public String getText() {
        StringBuilder builder = new StringBuilder();
        for (PatchLine line : this.myLines) {
            builder.append(line.getText()).append("\n");
        }
        return builder.toString();
    }

    public boolean isNoNewLineAtEnd() {
        if (this.myLines.isEmpty()) {
            return false;
        }
        return this.myLines.get(this.myLines.size() - 1).isSuppressNewLine();
    }
}

