/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.util.ArrayUtil;
import com.intellij.util.Base64Converter;
import com.intellij.util.PathUtilRt;
import java.io.UnsupportedEncodingException;

public class Attachment {
    private final String myPath;
    private final byte[] myBytes;
    private boolean myIncluded = true;
    private final String myDisplayText;

    public Attachment(String path, String content) {
        this.myPath = path;
        this.myDisplayText = content;
        this.myBytes = Attachment.getBytes(content);
    }

    public Attachment(String path, byte[] bytes, String displayText) {
        this.myPath = path;
        this.myBytes = bytes;
        this.myDisplayText = displayText;
    }

    public static byte[] getBytes(String content) {
        try {
            return content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
    }

    public String getDisplayText() {
        return this.myDisplayText;
    }

    public String getPath() {
        return this.myPath;
    }

    public String getName() {
        return PathUtilRt.getFileName(this.myPath);
    }

    public String getEncodedBytes() {
        return Base64Converter.encode(this.myBytes);
    }

    public boolean isIncluded() {
        return this.myIncluded;
    }

    public void setIncluded(Boolean included) {
        this.myIncluded = included;
    }
}

