/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;

public class ClassUtilCore {
    @NonNls
    static final String FILE_CACHE = "fileCache";
    @NonNls
    static final String URL_CACHE = "urlCache";

    public static void clearJarURLCache() {
        try {
            Class<?> jarFileFactory = Class.forName("sun.net.www.protocol.jar.JarFileFactory");
            ClassUtilCore.clearMap(jarFileFactory.getDeclaredField(FILE_CACHE));
            ClassUtilCore.clearMap(jarFileFactory.getDeclaredField(URL_CACHE));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void clearMap(Field cache) throws IllegalAccessException {
        cache.setAccessible(true);
        if ((cache.getModifiers() & 0x10) == 0) {
            cache.set(null, new HashMap());
        } else {
            Map map = (Map)cache.get(null);
            map.clear();
        }
    }

    public static boolean isLoadingOfExternalPluginsDisabled() {
        return !"true".equalsIgnoreCase(System.getProperty("idea.plugins.load", "true"));
    }
}

