/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeplatform.filesystem;

import net.rubygrapefruit.platform.Native;
import net.rubygrapefruit.platform.NativeIntegrationUnavailableException;
import net.rubygrapefruit.platform.PosixFiles;
import org.gradle.api.JavaVersion;
import org.gradle.internal.nativeplatform.filesystem.EmptyChmod;
import org.gradle.internal.nativeplatform.filesystem.FallbackStat;
import org.gradle.internal.nativeplatform.filesystem.FileModeAccessor;
import org.gradle.internal.nativeplatform.filesystem.FileModeMutator;
import org.gradle.internal.nativeplatform.filesystem.FileSystem;
import org.gradle.internal.nativeplatform.filesystem.GenericFileSystem;
import org.gradle.internal.nativeplatform.filesystem.NativePlatformBackedChmod;
import org.gradle.internal.nativeplatform.filesystem.NativePlatformBackedStat;
import org.gradle.internal.nativeplatform.filesystem.NativePlatformBackedSymlink;
import org.gradle.internal.nativeplatform.filesystem.UnsupportedFilePermissions;
import org.gradle.internal.nativeplatform.filesystem.UnsupportedSymlink;
import org.gradle.internal.nativeplatform.filesystem.WindowsSymlink;
import org.gradle.internal.os.OperatingSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemServices {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemServices.class);

    public FileSystem createFileSystem(OperatingSystem operatingSystem) throws Exception {
        if (operatingSystem.isWindows()) {
            return new GenericFileSystem(new EmptyChmod(), new FallbackStat(), new WindowsSymlink());
        }
        try {
            PosixFiles posixFiles = (PosixFiles)Native.get(PosixFiles.class);
            NativePlatformBackedSymlink symlink = new NativePlatformBackedSymlink(posixFiles);
            NativePlatformBackedChmod chmod = new NativePlatformBackedChmod(posixFiles);
            NativePlatformBackedStat stat = new NativePlatformBackedStat(posixFiles);
            return new GenericFileSystem(chmod, stat, symlink);
        }
        catch (NativeIntegrationUnavailableException ex) {
            LOGGER.debug("Native-platform file system integration is not available. Continuing with fallback.");
            LOGGER.debug("Using UnsupportedSymlink implementation.");
            UnsupportedSymlink symlink = new UnsupportedSymlink();
            if (JavaVersion.current().isJava7()) {
                String jdkFilePermissionclass = "org.gradle.internal.nativeplatform.filesystem.jdk7.PosixJdk7FilePermissionHandler";
                Class<?> handlerClass = null;
                try {
                    handlerClass = FileSystemServices.class.getClassLoader().loadClass(jdkFilePermissionclass);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.warn(String.format("Unable to load %s. Continuing with fallback.", jdkFilePermissionclass));
                }
                if (handlerClass != null) {
                    LOGGER.debug("Using JDK 7 file services.");
                    Object handler = handlerClass.newInstance();
                    return new GenericFileSystem((FileModeMutator)handler, (FileModeAccessor)handler, symlink);
                }
            }
            UnsupportedFilePermissions filePermissionsHandler = new UnsupportedFilePermissions();
            return new GenericFileSystem(filePermissionsHandler, filePermissionsHandler, symlink);
        }
    }
}

