/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ResourceFileUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.lw.IconDescriptor;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.IconEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.IconRenderer;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroIconProperty
extends IntrospectedProperty<IconDescriptor> {
    @NonNls
    private static final String CLIENT_PROPERTY_KEY_PREFIX = "IntroIconProperty_";
    private final LabelPropertyRenderer<IconDescriptor> myRenderer = new IconRenderer();
    private IconEditor myEditor;

    public IntroIconProperty(String name, Method readMethod, Method writeMethod, boolean storeAsClient) {
        super(name, readMethod, writeMethod, storeAsClient);
    }

    @Override
    public void write(@NotNull IconDescriptor value, XmlWriter writer) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/propertyInspector/properties/IntroIconProperty", "write"));
        }
        writer.addAttribute("value", value.getIconPath());
    }

    @Override
    @NotNull
    public PropertyRenderer<IconDescriptor> getRenderer() {
        LabelPropertyRenderer<IconDescriptor> labelPropertyRenderer = this.myRenderer;
        if (labelPropertyRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/IntroIconProperty", "getRenderer"));
        }
        return labelPropertyRenderer;
    }

    @Override
    @Nullable
    public PropertyEditor<IconDescriptor> getEditor() {
        if (this.myEditor == null) {
            this.myEditor = new IconEditor();
        }
        return this.myEditor;
    }

    @Override
    public IconDescriptor getValue(RadComponent component) {
        return (IconDescriptor)component.getDelegee().getClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName());
    }

    @Override
    protected void setValueImpl(RadComponent component, IconDescriptor value) throws Exception {
        component.getDelegee().putClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName(), value);
        if (value != null) {
            IntroIconProperty.ensureIconLoaded(component.getModule(), value);
            this.invokeSetter(component, value.getIcon());
        } else {
            this.invokeSetter(component, null);
        }
    }

    public static void ensureIconLoaded(Module module, IconDescriptor value) {
        VirtualFile iconFile;
        if (value.getIcon() == null && (iconFile = ResourceFileUtil.findResourceFileInScope((String)value.getIconPath(), (Project)module.getProject(), (GlobalSearchScope)module.getModuleWithDependenciesAndLibrariesScope(true))) != null) {
            IntroIconProperty.loadIconFromFile(iconFile, value);
        }
    }

    public static void loadIconFromFile(VirtualFile virtualFile, IconDescriptor descriptor) {
        if (virtualFile != null) {
            try {
                descriptor.setIcon((Icon)new ImageIcon(virtualFile.contentsToByteArray()));
            }
            catch (Exception e1) {
                descriptor.setIcon(null);
            }
        }
    }

    @Override
    public void resetValue(RadComponent component) throws Exception {
        component.getDelegee().putClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName(), null);
        super.setValueImpl(component, null);
        this.markTopmostModified(component, false);
    }
}

