/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.projectView;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uiDesigner.binding.FormClassIndex;
import java.util.Collection;
import java.util.HashSet;

public class Form
implements Navigatable {
    public static final DataKey<Form[]> DATA_KEY = DataKey.create((String)"form.array");
    private final Collection<PsiFile> myFormFiles;
    private final PsiClass myClassToBind;

    public Form(PsiClass classToBind) {
        this.myClassToBind = classToBind;
        this.myFormFiles = FormClassIndex.findFormsBoundToClass(classToBind);
    }

    public Form(PsiClass classToBind, Collection<PsiFile> formFiles) {
        this.myClassToBind = classToBind;
        this.myFormFiles = new HashSet<PsiFile>(formFiles);
    }

    public boolean equals(Object object) {
        if (object instanceof Form) {
            Form form = (Form)object;
            return ((Object)this.myFormFiles).equals(form.myFormFiles) && this.myClassToBind.equals(form.myClassToBind);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.myFormFiles).hashCode() ^ this.myClassToBind.hashCode();
    }

    public String getName() {
        return this.myClassToBind.getName();
    }

    public PsiClass getClassToBind() {
        return this.myClassToBind;
    }

    public PsiFile[] getFormFiles() {
        return PsiUtilCore.toPsiFileArray(this.myFormFiles);
    }

    public void navigate(boolean requestFocus) {
        for (PsiFile psiFile : this.myFormFiles) {
            if (psiFile == null || !psiFile.canNavigate()) continue;
            psiFile.navigate(requestFocus);
        }
    }

    public boolean canNavigateToSource() {
        for (PsiFile psiFile : this.myFormFiles) {
            if (psiFile == null || !psiFile.canNavigateToSource()) continue;
            return true;
        }
        return false;
    }

    public boolean canNavigate() {
        for (PsiFile psiFile : this.myFormFiles) {
            if (psiFile == null || !psiFile.canNavigate()) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        if (this.myFormFiles.size() == 0) {
            return false;
        }
        for (PsiFile psiFile : this.myFormFiles) {
            if (psiFile.isValid()) continue;
            return false;
        }
        return this.myClassToBind.isValid();
    }

    public boolean containsFile(VirtualFile vFile) {
        VirtualFile classVFile;
        PsiFile classFile = this.myClassToBind.getContainingFile();
        VirtualFile virtualFile = classVFile = classFile == null ? null : classFile.getVirtualFile();
        if (classVFile != null && classVFile.equals(vFile)) {
            return true;
        }
        for (PsiFile psiFile : this.myFormFiles) {
            VirtualFile virtualFile2 = psiFile.getVirtualFile();
            if (virtualFile2 == null || !virtualFile2.equals(vFile)) continue;
            return true;
        }
        return false;
    }
}

