/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.palette;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerProvider;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.palette.UIDesignerPaletteProvider;
import org.jetbrains.annotations.NotNull;

public class PaletteRefactoringListenerProvider
implements RefactoringElementListenerProvider {
    private final UIDesignerPaletteProvider myUiDesignerPaletteProvider;
    private final Palette myPalette;

    public PaletteRefactoringListenerProvider(UIDesignerPaletteProvider uiDesignerPaletteProvider, Palette palette) {
        this.myUiDesignerPaletteProvider = uiDesignerPaletteProvider;
        this.myPalette = palette;
    }

    public RefactoringElementListener getListener(PsiElement element) {
        ComponentItem item;
        PsiClass psiClass;
        String oldName;
        if (element instanceof PsiClass && (oldName = ClassUtil.getJVMClassName((PsiClass)(psiClass = (PsiClass)element))) != null && (item = this.myPalette.getItem(oldName)) != null) {
            return new MyRefactoringElementListener(item);
        }
        return null;
    }

    private class MyRefactoringElementListener
    extends RefactoringElementAdapter {
        private final ComponentItem myItem;

        public MyRefactoringElementListener(ComponentItem item) {
            this.myItem = item;
        }

        public void elementRenamedOrMoved(@NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/palette/PaletteRefactoringListenerProvider$MyRefactoringElementListener", "elementRenamedOrMoved"));
            }
            PsiClass psiClass = (PsiClass)newElement;
            String qName = ClassUtil.getJVMClassName((PsiClass)psiClass);
            if (qName != null) {
                this.myItem.setClassName(qName);
                PaletteRefactoringListenerProvider.this.myUiDesignerPaletteProvider.fireGroupsChanged();
            }
        }

        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
            if (newElement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/palette/PaletteRefactoringListenerProvider$MyRefactoringElementListener", "undoElementMovedOrRenamed"));
            }
            if (oldQualifiedName == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/uiDesigner/palette/PaletteRefactoringListenerProvider$MyRefactoringElementListener", "undoElementMovedOrRenamed"));
            }
            this.myItem.setClassName(oldQualifiedName);
            PaletteRefactoringListenerProvider.this.myUiDesignerPaletteProvider.fireGroupsChanged();
        }
    }
}

