/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.componentTree.ComponentTree;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.designSurface.Painter;
import com.intellij.uiDesigner.propertyInspector.UIDesignerToolWindowManager;
import com.intellij.uiDesigner.radComponents.RadButtonGroup;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.containers.HashSet;
import icons.UIDesignerIcons;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

class PassiveDecorationLayer
extends JComponent {
    @NotNull
    private final GuiEditor myEditor;

    public PassiveDecorationLayer(@NotNull GuiEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/designSurface/PassiveDecorationLayer", "<init>"));
        }
        this.myEditor = editor;
    }

    protected final void paintPassiveDecoration(RadComponent component, Graphics g) {
        Painter.paintComponentDecoration(this.myEditor, component, g);
        HashSet paintedGroups = new HashSet();
        final RadRootContainer rootContainer = this.myEditor.getRootContainer();
        ComponentTree componentTree = UIDesignerToolWindowManager.getInstance(component.getProject()).getComponentTree();
        List selectedGroups = componentTree != null ? componentTree.getSelectedElements(RadButtonGroup.class) : Collections.emptyList();
        FormEditingUtil.iterate(component, new FormEditingUtil.ComponentVisitor<RadComponent>((Set)paintedGroups, selectedGroups, g){
            final /* synthetic */ Set val$paintedGroups;
            final /* synthetic */ Collection val$selectedGroups;
            final /* synthetic */ Graphics val$g;
            {
                this.val$paintedGroups = set;
                this.val$selectedGroups = collection;
                this.val$g = graphics;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean visit(RadComponent component) {
                Point point = SwingUtilities.convertPoint(component.getDelegee(), 0, 0, rootContainer.getDelegee());
                RadButtonGroup group = (RadButtonGroup)FormEditingUtil.findGroupForComponent(rootContainer, component);
                if (group != null && !this.val$paintedGroups.contains(group) && (component.isSelected() || this.val$selectedGroups.contains(group))) {
                    this.val$paintedGroups.add(group);
                    Painter.paintButtonGroupLines(rootContainer, group, this.val$g);
                }
                this.val$g.translate(point.x, point.y);
                try {
                    if (PassiveDecorationLayer.this.myEditor.isShowComponentTags() && FormEditingUtil.isComponentSwitchedInView(component)) {
                        Painter.paintComponentTag(component, this.val$g);
                    }
                    Painter.paintSelectionDecoration(component, this.val$g, PassiveDecorationLayer.this.myEditor.getGlassLayer().isFocusOwner());
                    if (component.hasDragger()) {
                        Icon icon = PassiveDecorationLayer.getDragIcon();
                        icon.paintIcon(PassiveDecorationLayer.this, this.val$g, -icon.getIconWidth(), -icon.getIconHeight());
                    }
                }
                finally {
                    this.val$g.translate(-point.x, -point.y);
                }
                return true;
            }
        });
    }

    private static Icon getDragIcon() {
        return UIDesignerIcons.Drag;
    }

    @Override
    public void paint(Graphics g) {
        RadRootContainer root = this.myEditor.getRootContainer();
        for (int i = root.getComponentCount() - 1; i >= 0; --i) {
            RadComponent component = root.getComponent(i);
            this.paintPassiveDecoration(component, g);
        }
        this.paintChildren(g);
    }
}

