/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.designSurface;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.ide.palette.impl.PaletteManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.GridBuildUtil;
import com.intellij.uiDesigner.HSpacer;
import com.intellij.uiDesigner.LoaderFactory;
import com.intellij.uiDesigner.ModuleProvider;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.VSpacer;
import com.intellij.uiDesigner.compiler.NestedFormLoader;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.Util;
import com.intellij.uiDesigner.designSurface.ComponentDropLocation;
import com.intellij.uiDesigner.designSurface.ComponentItemDragObject;
import com.intellij.uiDesigner.designSurface.EventProcessor;
import com.intellij.uiDesigner.designSurface.GridInsertProcessor;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.make.PsiNestedFormLoader;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.ComponentItemDialog;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.uiDesigner.quickFixes.CreateFieldFix;
import com.intellij.uiDesigner.radComponents.RadAtomicComponent;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadComponentFactory;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadErrorComponent;
import com.intellij.uiDesigner.radComponents.RadHSpacer;
import com.intellij.uiDesigner.radComponents.RadNestedForm;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.uiDesigner.radComponents.RadScrollPane;
import com.intellij.uiDesigner.radComponents.RadSplitPane;
import com.intellij.uiDesigner.radComponents.RadTabbedPane;
import com.intellij.uiDesigner.radComponents.RadTable;
import com.intellij.uiDesigner.radComponents.RadToolBar;
import com.intellij.uiDesigner.radComponents.RadVSpacer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InsertComponentProcessor
extends EventProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.uiDesigner.designSurface.InsertComponentProcessor");
    private final PaletteManager myPaletteManager;
    private final GuiEditor myEditor;
    private boolean mySticky;
    private RadComponent myInsertedComponent;
    private final GridInsertProcessor myGridInsertProcessor;
    private ComponentItem myComponentToInsert;
    private ComponentDropLocation myLastLocation;
    private static final Map<String, RadComponentFactory> myComponentClassMap = new HashMap<String, RadComponentFactory>();

    public InsertComponentProcessor(@NotNull GuiEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/designSurface/InsertComponentProcessor", "<init>"));
        }
        this.myEditor = editor;
        this.myGridInsertProcessor = new GridInsertProcessor(editor);
        this.myPaletteManager = PaletteManager.getInstance((Project)editor.getProject());
    }

    public void setSticky(boolean sticky) {
        this.mySticky = sticky;
    }

    public void setComponentToInsert(ComponentItem componentToInsert) {
        this.myComponentToInsert = componentToInsert;
    }

    public void setLastLocation(ComponentDropLocation location) {
        ComponentItem componentToInsert = this.getComponentToInsert();
        assert (componentToInsert != null);
        ComponentItemDragObject dragObject = new ComponentItemDragObject(componentToInsert);
        if (location.canDrop(dragObject)) {
            this.myLastLocation = location;
        } else {
            ComponentDropLocation locationToRight = location.getAdjacentLocation(ComponentDropLocation.Direction.RIGHT);
            ComponentDropLocation locationToBottom = location.getAdjacentLocation(ComponentDropLocation.Direction.DOWN);
            this.myLastLocation = locationToRight != null && locationToRight.canDrop(dragObject) ? locationToRight : (locationToBottom != null && locationToBottom.canDrop(dragObject) ? locationToBottom : location);
        }
        if (this.myLastLocation.canDrop(dragObject)) {
            this.myLastLocation.placeFeedback(this.myEditor.getActiveDecorationLayer(), dragObject);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            if (e.getKeyCode() == 10) {
                if (this.myLastLocation != null) {
                    this.myEditor.getMainProcessor().stopCurrentProcessor();
                    this.processComponentInsert(this.getComponentToInsert(), this.myLastLocation);
                }
            } else {
                ComponentItem componentToInsert = this.getComponentToInsert();
                if (componentToInsert == null) {
                    this.cancelOperation();
                } else {
                    this.myLastLocation = InsertComponentProcessor.moveDropLocation(this.myEditor, this.myLastLocation, new ComponentItemDragObject(componentToInsert), e);
                }
            }
        }
    }

    @NotNull
    public static String suggestBinding(RadRootContainer rootContainer, @NotNull String componentClassName) {
        if (componentClassName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/uiDesigner/designSurface/InsertComponentProcessor", "suggestBinding"));
        }
        String shortClassName = InsertComponentProcessor.getShortClassName(componentClassName);
        LOG.assertTrue(shortClassName.length() > 0);
        String string = InsertComponentProcessor.getUniqueBinding(rootContainer, shortClassName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/designSurface/InsertComponentProcessor", "suggestBinding"));
        }
        return string;
    }

    public static String getShortClassName(@NonNls String componentClassName) {
        int lastDotIndex = componentClassName.lastIndexOf(46);
        String shortClassName = componentClassName.substring(lastDotIndex + 1);
        if (shortClassName.length() > 1 && Character.isUpperCase(shortClassName.charAt(1)) && componentClassName.startsWith("javax.swing.") && StringUtil.startsWithChar((CharSequence)shortClassName, (char)'J')) {
            shortClassName = shortClassName.substring(1);
        }
        shortClassName = StringUtil.decapitalize((String)shortClassName);
        return shortClassName;
    }

    public static String getUniqueBinding(RadRootContainer root, String baseName) {
        int i = 0;
        while (true) {
            String nameCandidate = baseName + (i + 1);
            String binding = JavaCodeStyleManager.getInstance((Project)root.getProject()).propertyNameToVariableName(nameCandidate, VariableKind.FIELD);
            if (FormEditingUtil.findComponentWithBinding(root, binding) == null) {
                return binding;
            }
            ++i;
        }
    }

    public static void createBindingWhenDrop(GuiEditor editor, RadComponent insertedComponent, boolean forceBinding) {
        ComponentItem item = Palette.getInstance(editor.getProject()).getItem(insertedComponent.getComponentClassName());
        if (item != null && item.isAutoCreateBinding() || insertedComponent.isCustomCreateRequired() || forceBinding) {
            InsertComponentProcessor.doCreateBindingWhenDrop(editor, insertedComponent);
        }
    }

    private static void doCreateBindingWhenDrop(GuiEditor editor, RadComponent insertedComponent) {
        String binding = InsertComponentProcessor.suggestBinding(editor.getRootContainer(), insertedComponent.getComponentClassName());
        insertedComponent.setBinding(binding);
        insertedComponent.setDefaultBinding(true);
        InsertComponentProcessor.createBindingField(editor, insertedComponent);
    }

    public static void createBindingField(final GuiEditor editor, final RadComponent insertedComponent) {
        PsiClass aClass;
        String classToBind = editor.getRootContainer().getClassToBind();
        if (classToBind != null && (aClass = FormEditingUtil.findClassToBind(editor.getModule(), classToBind)) != null && aClass.findFieldByName(insertedComponent.getBinding(), true) == null) {
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)aClass)) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    CreateFieldFix.runImpl(editor.getProject(), editor.getRootContainer(), aClass, insertedComponent.getComponentClassName(), insertedComponent.getBinding(), false, null);
                }
            });
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        ComponentItem componentToInsert;
        if (e.getID() == 501) {
            ComponentItem componentItem = this.getComponentToInsert();
            if (componentItem != null) {
                this.processComponentInsert(e.getPoint(), componentItem);
            }
        } else if (e.getID() == 503 && (componentToInsert = this.getComponentToInsert()) != null) {
            ComponentItemDragObject dragObject = new ComponentItemDragObject(componentToInsert);
            this.myLastLocation = this.myGridInsertProcessor.processDragEvent(e.getPoint(), dragObject);
            if (this.myLastLocation.canDrop(dragObject)) {
                this.setCursor(FormEditingUtil.getCopyDropCursor());
            } else {
                this.setCursor(FormEditingUtil.getMoveNoDropCursor());
            }
        }
    }

    @Nullable
    private ComponentItem getComponentToInsert() {
        return this.myComponentToInsert != null ? this.myComponentToInsert : (ComponentItem)this.myPaletteManager.getActiveItem(ComponentItem.class);
    }

    public void processComponentInsert(@NotNull Point point, ComponentItem item) {
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/designSurface/InsertComponentProcessor", "processComponentInsert"));
        }
        ComponentDropLocation location = GridInsertProcessor.getDropLocation(this.myEditor.getRootContainer(), point);
        this.processComponentInsert(item, location);
    }

    public void processComponentInsert(ComponentItem item, final ComponentDropLocation location) {
        this.myEditor.getActiveDecorationLayer().removeFeedback();
        this.myEditor.setDesignTimeInsets(2);
        item = InsertComponentProcessor.replaceAnyComponentItem(this.myEditor, item, UIDesignerBundle.message("palette.non.palette.component.title", new Object[0]));
        if (item == null) {
            return;
        }
        if (!this.validateNestedFormInsert(item)) {
            return;
        }
        if (!this.checkAddDependencyOnInsert(item)) {
            return;
        }
        if (!this.myEditor.ensureEditable()) {
            return;
        }
        final boolean forceBinding = item.isAutoCreateBinding();
        this.myInsertedComponent = InsertComponentProcessor.createInsertedComponent(this.myEditor, item);
        this.setCursor(Cursor.getDefaultCursor());
        if (this.myInsertedComponent == null) {
            if (!this.mySticky) {
                PaletteManager.getInstance((Project)this.myEditor.getProject()).clearActiveItem();
            }
            return;
        }
        final ComponentItemDragObject dragObject = new ComponentItemDragObject(item);
        if (location.canDrop(dragObject)) {
            CommandProcessor.getInstance().executeCommand(this.myEditor.getProject(), new Runnable(){

                @Override
                public void run() {
                    InsertComponentProcessor.createBindingWhenDrop(InsertComponentProcessor.this.myEditor, InsertComponentProcessor.this.myInsertedComponent, forceBinding);
                    RadComponent[] components = new RadComponent[]{InsertComponentProcessor.this.myInsertedComponent};
                    location.processDrop(InsertComponentProcessor.this.myEditor, components, null, dragObject);
                    FormEditingUtil.selectSingleComponent(InsertComponentProcessor.this.myEditor, InsertComponentProcessor.this.myInsertedComponent);
                    if (location.getContainer() != null && location.getContainer().isXY()) {
                        Dimension newSize = InsertComponentProcessor.this.myInsertedComponent.getPreferredSize();
                        Util.adjustSize((Component)InsertComponentProcessor.this.myInsertedComponent.getDelegee(), (GridConstraints)InsertComponentProcessor.this.myInsertedComponent.getConstraints(), (Dimension)newSize);
                        InsertComponentProcessor.this.myInsertedComponent.setSize(newSize);
                    }
                    if (InsertComponentProcessor.this.myInsertedComponent.getParent() instanceof RadRootContainer && InsertComponentProcessor.this.myInsertedComponent instanceof RadAtomicComponent) {
                        GridBuildUtil.convertToGrid(InsertComponentProcessor.this.myEditor);
                        FormEditingUtil.selectSingleComponent(InsertComponentProcessor.this.myEditor, InsertComponentProcessor.this.myInsertedComponent);
                    }
                    InsertComponentProcessor.this.checkBindTopLevelPanel();
                    if (!InsertComponentProcessor.this.mySticky) {
                        PaletteManager.getInstance((Project)InsertComponentProcessor.this.myEditor.getProject()).clearActiveItem();
                    }
                    InsertComponentProcessor.this.myEditor.refreshAndSave(false);
                }
            }, UIDesignerBundle.message("command.insert.component", new Object[0]), null);
        }
        this.myComponentToInsert = null;
    }

    private boolean checkAddDependencyOnInsert(ComponentItem item) {
        ProjectFileIndex fileIndex;
        List entries;
        if (item.getClassName().equals(HSpacer.class.getName()) || item.getClassName().equals(VSpacer.class.getName())) {
            return true;
        }
        PsiManager manager = PsiManager.getInstance((Project)this.myEditor.getProject());
        GlobalSearchScope projectScope = GlobalSearchScope.allScope((Project)this.myEditor.getProject());
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myEditor.getModule());
        PsiClass componentClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(item.getClassName(), projectScope);
        return componentClass == null || JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(item.getClassName(), moduleScope) != null || (entries = (fileIndex = ProjectRootManager.getInstance((Project)this.myEditor.getProject()).getFileIndex()).getOrderEntriesForFile(componentClass.getContainingFile().getVirtualFile())).size() <= 0 || !(entries.get(0) instanceof ModuleSourceOrderEntry ? !this.checkAddModuleDependency(item, (ModuleSourceOrderEntry)entries.get(0)) : entries.get(0) instanceof LibraryOrderEntry && !this.checkAddLibraryDependency(item, (LibraryOrderEntry)entries.get(0)));
    }

    private boolean checkAddModuleDependency(ComponentItem item, ModuleSourceOrderEntry moduleSourceOrderEntry) {
        Module ownerModule = moduleSourceOrderEntry.getOwnerModule();
        int rc = Messages.showYesNoCancelDialog((Component)this.myEditor, (String)UIDesignerBundle.message("add.module.dependency.prompt", item.getClassName(), ownerModule.getName(), this.myEditor.getModule().getName()), (String)UIDesignerBundle.message("add.module.dependency.title", new Object[0]), (Icon)Messages.getQuestionIcon());
        if (rc == 2) {
            return false;
        }
        if (rc == 0) {
            ModuleRootModificationUtil.addDependency((Module)this.myEditor.getModule(), (Module)ownerModule);
        }
        return true;
    }

    private boolean checkAddLibraryDependency(ComponentItem item, final LibraryOrderEntry libraryOrderEntry) {
        int rc = Messages.showYesNoCancelDialog((Component)this.myEditor, (String)UIDesignerBundle.message("add.library.dependency.prompt", item.getClassName(), libraryOrderEntry.getPresentableName(), this.myEditor.getModule().getName()), (String)UIDesignerBundle.message("add.library.dependency.title", new Object[0]), (Icon)Messages.getQuestionIcon());
        if (rc == 2) {
            return false;
        }
        if (rc == 0) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    ModifiableRootModel model = ModuleRootManager.getInstance((Module)InsertComponentProcessor.this.myEditor.getModule()).getModifiableModel();
                    if (libraryOrderEntry.isModuleLevel()) {
                        InsertComponentProcessor.copyModuleLevelLibrary(libraryOrderEntry.getLibrary(), model);
                    } else {
                        model.addLibraryEntry(libraryOrderEntry.getLibrary());
                    }
                    model.commit();
                }
            });
        }
        return true;
    }

    private static void copyModuleLevelLibrary(Library fromLibrary, ModifiableRootModel toModel) {
        LibraryTable.ModifiableModel libraryTableModel = toModel.getModuleLibraryTable().getModifiableModel();
        Library library = libraryTableModel.createLibrary(null);
        Library.ModifiableModel libraryModel = library.getModifiableModel();
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            for (String url : fromLibrary.getUrls(rootType)) {
                libraryModel.addRoot(url, rootType);
            }
        }
        libraryModel.commit();
        libraryTableModel.commit();
    }

    private boolean validateNestedFormInsert(ComponentItem item) {
        PsiFile boundForm = item.getBoundForm();
        if (boundForm != null) {
            try {
                String formName = FormEditingUtil.buildResourceName(boundForm);
                String targetForm = FormEditingUtil.buildResourceName(this.myEditor.getPsiFile());
                Utils.validateNestedFormLoop((String)formName, (NestedFormLoader)new PsiNestedFormLoader(this.myEditor.getModule()), (String)targetForm);
            }
            catch (Exception ex) {
                Messages.showErrorDialog((Component)this.myEditor, (String)ex.getMessage(), (String)CommonBundle.getErrorTitle());
                return false;
            }
        }
        return true;
    }

    public static RadContainer createPanelComponent(GuiEditor editor) {
        RadComponent c = InsertComponentProcessor.createInsertedComponent(editor, Palette.getInstance(editor.getProject()).getPanelItem());
        LOG.assertTrue(c != null);
        return (RadContainer)c;
    }

    @Nullable
    public static ComponentItem replaceAnyComponentItem(GuiEditor editor, ComponentItem item, String title) {
        if (item.isAnyComponent()) {
            ComponentItem newItem = item.clone();
            ComponentItemDialog dlg = new ComponentItemDialog(editor.getProject(), editor, newItem, true);
            dlg.setTitle(title);
            dlg.show();
            if (!dlg.isOK()) {
                return null;
            }
            return newItem;
        }
        return item;
    }

    @Nullable
    public static RadComponent createInsertedComponent(GuiEditor editor, ComponentItem item) {
        RadComponent result;
        String id = FormEditingUtil.generateId(editor.getRootContainer());
        ClassLoader loader = LoaderFactory.getInstance(editor.getProject()).getLoader(editor.getFile());
        RadComponentFactory factory = InsertComponentProcessor.getRadComponentFactory(item.getClassName(), loader);
        if (factory != null) {
            try {
                result = factory.newInstance((ModuleProvider)editor, item.getClassName(), id);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        PsiFile boundForm = item.getBoundForm();
        if (boundForm != null) {
            String formFileName = FormEditingUtil.buildResourceName(boundForm);
            try {
                result = new RadNestedForm((ModuleProvider)editor, formFileName, id);
            }
            catch (Exception ex) {
                String errorMessage = UIDesignerBundle.message("error.instantiating.nested.form", formFileName, ex.getMessage() != null ? ex.getMessage() : ex.toString());
                result = RadErrorComponent.create(editor, id, item.getClassName(), null, errorMessage);
            }
        } else {
            try {
                Class<?> aClass = Class.forName(item.getClassName(), true, loader);
                if (item.isContainer()) {
                    LOG.debug("Creating custom container instance");
                    result = new RadContainer(editor, aClass, id);
                } else {
                    result = new RadAtomicComponent(editor, aClass, id);
                }
            }
            catch (UnsupportedClassVersionError ucve) {
                result = RadErrorComponent.create(editor, id, item.getClassName(), null, UIDesignerBundle.message("unsupported.component.class.version", new Object[0]));
            }
            catch (Exception exc) {
                String errorDescription = Utils.validateJComponentClass((ClassLoader)loader, (String)item.getClassName(), (boolean)true);
                if (errorDescription == null) {
                    errorDescription = UIDesignerBundle.message("error.class.cannot.be.instantiated", item.getClassName());
                    String message = FormEditingUtil.getExceptionMessage(exc);
                    if (message != null) {
                        errorDescription = errorDescription + ": " + message;
                    }
                }
                result = RadErrorComponent.create(editor, id, item.getClassName(), null, errorDescription);
            }
        }
        result.init(editor, item);
        return result;
    }

    @Nullable
    public static RadComponentFactory getRadComponentFactory(Project project, String className) {
        ClassLoader loader = LoaderFactory.getInstance(project).getProjectClassLoader();
        return InsertComponentProcessor.getRadComponentFactory(className, loader);
    }

    @Nullable
    private static RadComponentFactory getRadComponentFactory(String className, ClassLoader loader) {
        Class<?> componentClass;
        try {
            componentClass = Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException e) {
            return myComponentClassMap.get(className);
        }
        return InsertComponentProcessor.getRadComponentFactory(componentClass);
    }

    @Nullable
    public static RadComponentFactory getRadComponentFactory(Class componentClass) {
        while (componentClass != null) {
            RadComponentFactory c = myComponentClassMap.get(componentClass.getName());
            if (c != null) {
                return c;
            }
            if (!JPanel.class.equals(componentClass = componentClass.getSuperclass())) continue;
            return null;
        }
        return null;
    }

    private void checkBindTopLevelPanel() {
        RadComponent component;
        if (this.myEditor.getRootContainer().getComponentCount() == 1 && (component = this.myEditor.getRootContainer().getComponent(0)).getBinding() == null && (component == this.myInsertedComponent || component instanceof RadContainer && ((RadContainer)component).getComponentCount() == 1 && component == this.myInsertedComponent.getParent())) {
            InsertComponentProcessor.doCreateBindingWhenDrop(this.myEditor, component);
        }
    }

    @Override
    protected boolean cancelOperation() {
        this.myEditor.setDesignTimeInsets(2);
        this.myEditor.getActiveDecorationLayer().removeFeedback();
        return true;
    }

    public Cursor processMouseMoveEvent(MouseEvent e) {
        ComponentItem componentItem = (ComponentItem)this.myPaletteManager.getActiveItem(ComponentItem.class);
        if (componentItem != null) {
            return this.myGridInsertProcessor.processMouseMoveEvent(e.getPoint(), false, new ComponentItemDragObject(componentItem));
        }
        return FormEditingUtil.getMoveNoDropCursor();
    }

    @Override
    public boolean needMousePressed() {
        return true;
    }

    static {
        myComponentClassMap.put(JScrollPane.class.getName(), new RadScrollPane.Factory());
        myComponentClassMap.put(JPanel.class.getName(), new RadContainer.Factory());
        myComponentClassMap.put(VSpacer.class.getName(), new RadVSpacer.Factory());
        myComponentClassMap.put(HSpacer.class.getName(), new RadHSpacer.Factory());
        myComponentClassMap.put(JTabbedPane.class.getName(), new RadTabbedPane.Factory());
        myComponentClassMap.put(JSplitPane.class.getName(), new RadSplitPane.Factory());
        myComponentClassMap.put(JToolBar.class.getName(), new RadToolBar.Factory());
        myComponentClassMap.put(JTable.class.getName(), new RadTable.Factory());
    }
}

