/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GeneratedCodeFoldingBuilder
extends FoldingBuilderEx {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/binding/GeneratedCodeFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/uiDesigner/binding/GeneratedCodeFoldingBuilder", "buildFoldRegions"));
        }
        MyFoldingVisitor visitor = new MyFoldingVisitor();
        root.accept((PsiElementVisitor)visitor);
        FoldingDescriptor[] foldingDescriptorArray = visitor.myFoldingData.toArray(new FoldingDescriptor[visitor.myFoldingData.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/GeneratedCodeFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/binding/GeneratedCodeFoldingBuilder", "getPlaceholderText"));
        }
        return UIDesignerBundle.message("uidesigner.generated.code.folding.placeholder.text", new Object[0]);
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/binding/GeneratedCodeFoldingBuilder", "isCollapsedByDefault"));
        }
        return true;
    }

    private static boolean isGeneratedUIInitializer(PsiClassInitializer initializer) {
        PsiCodeBlock body = initializer.getBody();
        if (body.getStatements().length != 1) {
            return false;
        }
        PsiStatement statement = body.getStatements()[0];
        if (!(statement instanceof PsiExpressionStatement) || !(((PsiExpressionStatement)statement).getExpression() instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)((PsiExpressionStatement)statement).getExpression();
        return "$$$setupUI$$$".equals(call.getMethodExpression().getReferenceName());
    }

    private static class MyFoldingVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private PsiElement myLastElement;
        private final List<FoldingDescriptor> myFoldingData = new ArrayList<FoldingDescriptor>();

        private MyFoldingVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            if ("$$$setupUI$$$".equals(method.getName()) || "$$$getRootComponent$$$".equals(method.getName()) || "$$$loadButtonText$$$".equals(method.getName()) || "$$$loadLabelText$$$".equals(method.getName())) {
                this.addFoldingData((PsiElement)method);
            }
        }

        public void visitClassInitializer(PsiClassInitializer initializer) {
            if (GeneratedCodeFoldingBuilder.isGeneratedUIInitializer(initializer)) {
                this.addFoldingData((PsiElement)initializer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFoldingData(PsiElement element) {
            PsiElement prevSibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class});
            List<FoldingDescriptor> list = this.myFoldingData;
            synchronized (list) {
                if (this.myLastElement == null || prevSibling != this.myLastElement) {
                    this.myFoldingData.add(new FoldingDescriptor(element, element.getTextRange()));
                } else {
                    FoldingDescriptor lastDescriptor = this.myFoldingData.get(this.myFoldingData.size() - 1);
                    TextRange range = new TextRange(lastDescriptor.getRange().getStartOffset(), element.getTextRange().getEndOffset());
                    this.myFoldingData.set(this.myFoldingData.size() - 1, new FoldingDescriptor(lastDescriptor.getElement(), range));
                }
            }
            this.myLastElement = element;
        }
    }
}

