/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FormReferencesSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        LocalSearchScope filterScope;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/binding/FormReferencesSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/uiDesigner/binding/FormReferencesSearcher", "execute"));
        }
        if (!FormReferencesSearcher.scopeCanContainForms(p.getScope())) {
            return true;
        }
        final PsiElement refElement = p.getElementToSearch();
        PsiFile psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

            public PsiFile compute() {
                if (!refElement.isValid()) {
                    return null;
                }
                return refElement.getContainingFile();
            }
        });
        if (psiFile == null) {
            return true;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        Module module = ProjectRootManager.getInstance((Project)refElement.getProject()).getFileIndex().getModuleForFile(virtualFile);
        if (module == null) {
            return true;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesScope((Module)module);
        LocalSearchScope localSearchScope = filterScope = p.getScope() instanceof LocalSearchScope ? (LocalSearchScope)p.getScope() : null;
        return refElement instanceof PsiPackage || !(refElement instanceof PsiClass ? !FormReferencesSearcher.processReferencesInUIForms(consumer, (PsiClass)refElement, scope, filterScope) : (refElement instanceof PsiEnumConstant ? !FormReferencesSearcher.processReferencesInUIForms(consumer, (PsiEnumConstant)refElement, scope, filterScope) : (refElement instanceof PsiField ? !FormReferencesSearcher.processReferencesInUIForms(consumer, (PsiField)refElement, scope, filterScope) : (refElement instanceof IProperty ? !FormReferencesSearcher.processReferencesInUIForms(consumer, (Property)refElement, scope, filterScope) : refElement instanceof PropertiesFile && !FormReferencesSearcher.processReferencesInUIForms(consumer, (PropertiesFile)refElement, scope, filterScope)))));
    }

    private static boolean scopeCanContainForms(SearchScope scope) {
        PsiElement[] elements;
        if (!(scope instanceof LocalSearchScope)) {
            return true;
        }
        LocalSearchScope localSearchScope = (LocalSearchScope)scope;
        for (PsiElement element : elements = localSearchScope.getScope()) {
            PsiFile file;
            if (element instanceof PsiDirectory) {
                return true;
            }
            if (element instanceof PsiFile) {
                file = (PsiFile)element;
            } else {
                if (!element.isValid()) continue;
                file = element.getContainingFile();
            }
            if (file.getFileType() != StdFileTypes.GUI_DESIGNER_FORM) continue;
            return true;
        }
        return false;
    }

    private static boolean processReferencesInUIForms(Processor<PsiReference> processor, PsiClass aClass, GlobalSearchScope scope, LocalSearchScope filterScope) {
        PsiManagerImpl manager = (PsiManagerImpl)aClass.getManager();
        String className = FormReferencesSearcher.getQualifiedName(aClass);
        return className == null || FormReferencesSearcher.processReferencesInUIFormsInner(className, (PsiElement)aClass, processor, scope, manager, filterScope);
    }

    public static String getQualifiedName(final PsiClass aClass) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                if (!aClass.isValid()) {
                    return null;
                }
                return aClass.getQualifiedName();
            }
        });
    }

    private static boolean processReferencesInUIForms(Processor<PsiReference> processor, final PsiEnumConstant enumConstant, GlobalSearchScope scope, LocalSearchScope filterScope) {
        PsiManagerImpl manager = (PsiManagerImpl)enumConstant.getManager();
        String className = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return enumConstant.getName();
            }
        });
        return className == null || FormReferencesSearcher.processReferencesInUIFormsInner(className, (PsiElement)enumConstant, processor, scope, manager, filterScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processReferencesInUIFormsInner(String name, PsiElement element, Processor<PsiReference> processor, GlobalSearchScope scope1, PsiManagerImpl manager, LocalSearchScope filterScope) {
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)manager.getProject()).intersectWith(scope1);
        manager.startBatchFilesProcessingMode();
        try {
            List<PsiFile> files = FormClassIndex.findFormsBoundToClass(manager.getProject(), name, scope);
            for (PsiFile file : files) {
                ProgressManager.checkCanceled();
                if (file.getFileType() != StdFileTypes.GUI_DESIGNER_FORM) continue;
                if (FormReferencesSearcher.processReferences(processor, file, name, element, filterScope)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            manager.finishBatchFilesProcessingMode();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processReferencesInUIForms(Processor<PsiReference> processor, PsiField field, GlobalSearchScope scope1, LocalSearchScope filterScope) {
        String fieldName;
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)field.getProject()).intersectWith(scope1);
        PsiManagerImpl manager = (PsiManagerImpl)field.getManager();
        PsiClass containingClass = field.getContainingClass();
        if (containingClass == null) {
            return true;
        }
        AccessToken token = ReadAction.start();
        try {
            fieldName = field.getName();
        }
        finally {
            token.finish();
        }
        manager.startBatchFilesProcessingMode();
        try {
            List<PsiFile> files = FormClassIndex.findFormsBoundToClass(containingClass, scope);
            for (PsiFile file : files) {
                ProgressManager.checkCanceled();
                if (file.getFileType() != StdFileTypes.GUI_DESIGNER_FORM) continue;
                if (FormReferencesSearcher.processReferences(processor, file, fieldName, (PsiElement)field, filterScope)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            manager.finishBatchFilesProcessingMode();
        }
        return true;
    }

    private static boolean processReferences(final Processor<PsiReference> processor, final PsiFile file, String name, final PsiElement element, final LocalSearchScope filterScope) {
        CharSequence chars = (CharSequence)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<CharSequence>(){

            public CharSequence compute() {
                if (filterScope != null) {
                    boolean isInScope = false;
                    for (PsiElement filterElement : filterScope.getScope()) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)filterElement, (PsiElement)file, (boolean)false)) continue;
                        isInScope = true;
                        break;
                    }
                    if (!isInScope) {
                        return null;
                    }
                }
                return file.getViewProvider().getContents();
            }
        });
        if (chars == null) {
            return true;
        }
        int index = 0;
        final int offset = name.lastIndexOf(46);
        while ((index = CharArrayUtil.indexOf((CharSequence)chars, (CharSequence)name, (int)index)) >= 0) {
            final int finalIndex = index++;
            Boolean searchDone = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<Boolean>(){

                public Boolean compute() {
                    PsiReference ref = file.findReferenceAt(finalIndex + offset + 1);
                    if (ref != null && ref.isReferenceTo(element)) {
                        return processor.process((Object)ref);
                    }
                    return true;
                }
            });
            if (searchDone.booleanValue()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processReferencesInUIForms(Processor<PsiReference> processor, final Property property, GlobalSearchScope globalSearchScope, LocalSearchScope filterScope) {
        final Project project = property.getProject();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project).intersectWith(globalSearchScope);
        PsiManagerImpl manager = (PsiManagerImpl)property.getManager();
        String name = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                return property.getName();
            }
        });
        if (name == null) {
            return true;
        }
        manager.startBatchFilesProcessingMode();
        try {
            CommonProcessors.CollectProcessor<VirtualFile> collector = new CommonProcessors.CollectProcessor<VirtualFile>(){

                protected boolean accept(VirtualFile virtualFile) {
                    return virtualFile.getFileType() == StdFileTypes.GUI_DESIGNER_FORM;
                }
            };
            ((PsiSearchHelperImpl)PsiSearchHelper.SERVICE.getInstance((Project)project)).processFilesWithText(scope, (short)16, true, name, (Processor)collector);
            for (final VirtualFile vfile : collector.getResults()) {
                ProgressManager.checkCanceled();
                PsiFile file = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

                    public PsiFile compute() {
                        return PsiManager.getInstance((Project)project).findFile(vfile);
                    }
                });
                if (FormReferencesSearcher.processReferences(processor, file, name, (PsiElement)property, filterScope)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            manager.finishBatchFilesProcessingMode();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean processReferencesInUIForms(Processor<PsiReference> processor, PropertiesFile propFile, GlobalSearchScope globalSearchScope, LocalSearchScope filterScope) {
        Project project = propFile.getProject();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project).intersectWith(globalSearchScope);
        PsiManagerImpl manager = (PsiManagerImpl)propFile.getContainingFile().getManager();
        String baseName = propFile.getResourceBundle().getBaseName();
        manager.startBatchFilesProcessingMode();
        try {
            PsiFile[] files;
            for (PsiFile file : files = CacheManager.SERVICE.getInstance((Project)project).getFilesWithWord(baseName, (short)16, scope, true)) {
                ProgressManager.checkCanceled();
                if (file.getFileType() != StdFileTypes.GUI_DESIGNER_FORM || FormReferencesSearcher.processReferences(processor, file, baseName, (PsiElement)propFile.getContainingFile(), filterScope)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            manager.finishBatchFilesProcessingMode();
        }
        return true;
    }
}

