/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.uiDesigner.binding.ReferenceInForm;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class FormPackageReference
extends ReferenceInForm {
    protected FormPackageReference(PsiPlainTextFile file, TextRange range) {
        super(file, range);
    }

    public PsiElement resolve() {
        Project project = this.myFile.getProject();
        String text = this.getRangeText().replace('/', '.');
        return JavaPsiFacade.getInstance((Project)project).findPackage(text);
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof PsiPackage)) {
            return false;
        }
        String qName = ((PsiPackage)element).getQualifiedName().replace('.', '/');
        String rangeText = this.getRangeText();
        return qName.equals(rangeText);
    }

    @Override
    public PsiElement handleElementRename(String newElementName) {
        String s = this.getRangeText();
        int pos = s.lastIndexOf("/");
        if (pos < 0) {
            this.updateRangeText(newElementName);
        } else {
            this.updateRangeText(s.substring(0, pos + 1) + newElementName);
        }
        return this.myFile;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/binding/FormPackageReference", "bindToElement"));
        }
        return this.myFile;
    }
}

