/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReference;
import com.intellij.uiDesigner.binding.ReferenceInForm;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FieldFormReference
extends ReferenceInForm {
    private final PsiReference myClassReference;
    private final String myComponentClassName;
    private final TextRange myComponentClassNameRange;
    private final boolean myCustomCreate;

    public FieldFormReference(PsiPlainTextFile file, PsiReference aClass, TextRange fieldNameRange, @Nullable String componentClassName, @Nullable TextRange componentClassNameRange, boolean customCreate) {
        super(file, fieldNameRange);
        this.myClassReference = aClass;
        this.myComponentClassName = componentClassName;
        this.myComponentClassNameRange = componentClassNameRange;
        this.myCustomCreate = customCreate;
    }

    public PsiElement resolve() {
        PsiElement element = this.myClassReference.resolve();
        if (element instanceof PsiClass) {
            return ((PsiClass)element).findFieldByName(this.getRangeText(), true);
        }
        return null;
    }

    @Nullable
    public String getComponentClassName() {
        return this.myComponentClassName;
    }

    @Nullable
    public TextRange getComponentClassNameTextRange() {
        return this.myComponentClassNameRange;
    }

    public boolean isCustomCreate() {
        return this.myCustomCreate;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/binding/FieldFormReference", "bindToElement"));
        }
        if (!(element instanceof PsiField)) {
            throw new IncorrectOperationException();
        }
        PsiField field = (PsiField)element;
        if (!this.myClassReference.equals(field.getContainingClass())) {
            throw new IncorrectOperationException();
        }
        String text = field.getName();
        this.updateRangeText(text);
        return this.myFile;
    }
}

