/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.binding;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.binding.FormClassIndex;
import com.intellij.uiDesigner.editor.UIFormEditor;
import com.intellij.uiDesigner.palette.ComponentItem;
import com.intellij.uiDesigner.palette.Palette;
import com.intellij.util.PlatformIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoundIconRenderer
extends GutterIconRenderer {
    @NotNull
    private final PsiElement myElement;
    private Icon myIcon;
    private final String myQName;

    public BoundIconRenderer(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/binding/BoundIconRenderer", "<init>"));
        }
        this.myElement = element;
        if (this.myElement instanceof PsiField) {
            ComponentItem item;
            String qName;
            PsiClass componentClass;
            PsiField field = (PsiField)this.myElement;
            PsiType type = field.getType();
            if (type instanceof PsiClassType && (componentClass = ((PsiClassType)type).resolve()) != null && (qName = componentClass.getQualifiedName()) != null && (item = Palette.getInstance(this.myElement.getProject()).getItem(qName)) != null) {
                this.myIcon = item.getIcon();
            }
            this.myQName = field.getContainingClass().getQualifiedName() + "#" + field.getName();
        } else {
            this.myQName = ((PsiClass)element).getQualifiedName();
        }
    }

    @NotNull
    public Icon getIcon() {
        if (this.myIcon != null) {
            Icon icon = this.myIcon;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/BoundIconRenderer", "getIcon"));
            }
            return icon;
        }
        Icon icon = PlatformIcons.UI_FORM_ICON;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/binding/BoundIconRenderer", "getIcon"));
        }
        return icon;
    }

    public boolean isNavigateAction() {
        return true;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                List formFiles = BoundIconRenderer.this.getBoundFormFiles();
                if (formFiles.size() > 0) {
                    VirtualFile virtualFile = ((PsiFile)formFiles.get(0)).getVirtualFile();
                    if (virtualFile == null) {
                        return;
                    }
                    Project project = BoundIconRenderer.this.myElement.getProject();
                    FileEditor[] editors = FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
                    if (BoundIconRenderer.this.myElement instanceof PsiField) {
                        for (FileEditor editor : editors) {
                            if (!(editor instanceof UIFormEditor)) continue;
                            ((UIFormEditor)editor).selectComponent(((PsiField)BoundIconRenderer.this.myElement).getName());
                        }
                    }
                }
            }
        };
    }

    @Nullable
    public String getTooltipText() {
        List<PsiFile> formFiles = this.getBoundFormFiles();
        if (formFiles.size() > 0) {
            return BoundIconRenderer.composeText(formFiles);
        }
        return super.getTooltipText();
    }

    private List<PsiFile> getBoundFormFiles() {
        List<PsiFile> formFiles = Collections.emptyList();
        PsiClass aClass = this.myElement instanceof PsiField ? ((PsiField)this.myElement).getContainingClass() : (PsiClass)this.myElement;
        if (aClass != null && aClass.getQualifiedName() != null) {
            formFiles = FormClassIndex.findFormsBoundToClass(aClass);
        }
        return formFiles;
    }

    private static String composeText(List<PsiFile> formFiles) {
        StringBuilder result = new StringBuilder("<html><body>");
        result.append(UIDesignerBundle.message("ui.is.bound.header", new Object[0]));
        String sep = "";
        for (PsiFile file : formFiles) {
            result.append(sep);
            sep = "<br>";
            result.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            result.append(file.getName());
        }
        result.append("</body></html>");
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BoundIconRenderer that = (BoundIconRenderer)((Object)o);
        if (!this.myQName.equals(that.myQName)) {
            return false;
        }
        return !(this.myIcon != null ? !this.myIcon.equals(that.myIcon) : that.myIcon != null);
    }

    public int hashCode() {
        int result = this.myElement.hashCode();
        result = 31 * result + (this.myIcon != null ? this.myIcon.hashCode() : 0);
        return result;
    }
}

