/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.uiDesigner.actions.AbstractGuiEditorAction;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.properties.IndentProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class IncreaseIndentAction
extends AbstractGuiEditorAction {
    public IncreaseIndentAction() {
        super(true);
    }

    @Override
    protected void actionPerformed(GuiEditor editor, List<RadComponent> selection, AnActionEvent e) {
        IndentProperty indentProperty = IndentProperty.getInstance(editor.getProject());
        for (RadComponent c : selection) {
            int indent = indentProperty.getValue(c);
            indentProperty.setValueEx(c, this.adjustIndent(indent));
        }
    }

    @Override
    protected void update(@NotNull GuiEditor editor, ArrayList<RadComponent> selection, AnActionEvent e) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/uiDesigner/actions/IncreaseIndentAction", "update"));
        }
        boolean applicable = this.canAdjustIndent(selection);
        e.getPresentation().setVisible(applicable);
        Component focusOwner = IdeFocusManager.findInstanceByComponent((Component)editor).getFocusOwner();
        e.getPresentation().setEnabled(applicable && (focusOwner == editor || editor.isAncestorOf(focusOwner)));
    }

    private boolean canAdjustIndent(ArrayList<RadComponent> selection) {
        for (RadComponent c : selection) {
            if (!this.canAdjustIndent(c)) continue;
            return true;
        }
        return false;
    }

    protected int adjustIndent(int indent) {
        return indent + 1;
    }

    protected boolean canAdjustIndent(RadComponent component) {
        return component.getParent().getLayout() instanceof GridLayoutManager;
    }
}

