/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.SelectionState;
import com.intellij.uiDesigner.componentTree.ComponentPtr;
import com.intellij.uiDesigner.componentTree.ComponentTreeBuilder;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.propertyInspector.UIDesignerToolWindowManager;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import java.util.Stack;

public final class ExpandSelectionAction
extends AnAction {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        GuiEditor editor = FormEditingUtil.getEditorFromContext(e.getDataContext());
        assert (editor != null);
        SelectionState selectionState = editor.getSelectionState();
        selectionState.setInsideChange(true);
        ComponentTreeBuilder builder = UIDesignerToolWindowManager.getInstance(editor.getProject()).getComponentTreeBuilder();
        if (builder != null) {
            builder.beginUpdateSelection();
        }
        Stack<ComponentPtr[]> history = selectionState.getSelectionHistory();
        try {
            ComponentPtr[] ptrs = history.peek();
            for (int i = ptrs.length - 1; i >= 0; --i) {
                RadComponent component;
                RadContainer parent;
                ComponentPtr ptr = ptrs[i];
                ptr.validate();
                if (!ptr.isValid() || (parent = (component = ptr.getComponent()).getParent()) == null) continue;
                boolean shouldSelectParent = true;
                for (int j = parent.getComponentCount() - 1; j >= 0; --j) {
                    RadComponent sibling = parent.getComponent(j);
                    if (sibling.isSelected()) continue;
                    shouldSelectParent = false;
                    sibling.setSelected(true);
                }
                if (!shouldSelectParent) continue;
                parent.setSelected(true);
            }
            history.push(SelectionState.getSelection(editor));
        }
        finally {
            if (builder != null) {
                builder.endUpdateSelection();
            }
            selectionState.setInsideChange(false);
        }
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        GuiEditor editor = FormEditingUtil.getEditorFromContext(e.getDataContext());
        if (editor == null) {
            presentation.setEnabled(false);
            return;
        }
        SelectionState selectionState = editor.getSelectionState();
        selectionState.setInsideChange(true);
        Stack<ComponentPtr[]> history = selectionState.getSelectionHistory();
        presentation.setEnabled(!history.isEmpty());
    }
}

