/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.lang.Language;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TIntLongHashMap;
import gnu.trove.TIntProcedure;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@State(name="PropertiesSeparatorManager", storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class PropertiesSeparatorManager
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String FILE_ELEMENT = "file";
    @NonNls
    private static final String URL_ELEMENT = "url";
    @NonNls
    private static final String SEPARATOR_ATTR = "separator";
    private final Map<VirtualFile, String> mySeparators = new THashMap();

    public static PropertiesSeparatorManager getInstance() {
        return (PropertiesSeparatorManager)ServiceManager.getService(PropertiesSeparatorManager.class);
    }

    public String getSeparator(Project project, VirtualFile file) {
        String separator = this.mySeparators.get(file);
        if (separator == null) {
            separator = PropertiesSeparatorManager.guessSeparator(project, file);
            this.setSeparator(file, separator);
        }
        return separator;
    }

    private static String guessSeparator(Project project, VirtualFile file) {
        SmartList files;
        if (file instanceof ResourceBundleAsVirtualFile) {
            files = ((ResourceBundleAsVirtualFile)file).getResourceBundle().getPropertiesFiles(project);
        } else {
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            FileViewProvider provider = psiManager.findViewProvider(file);
            files = new SmartList();
            if (provider != null) {
                ContainerUtil.addIfNotNull((Object)((PropertiesFile)provider.getPsi((Language)PropertiesLanguage.INSTANCE)), (Collection)files);
            }
        }
        final TIntLongHashMap charCounts = new TIntLongHashMap();
        for (PropertiesFile propertiesFile : files) {
            if (propertiesFile == null) continue;
            List<IProperty> properties = propertiesFile.getProperties();
            for (IProperty property : properties) {
                String key = property.getUnescapedKey();
                if (key == null) continue;
                for (int i = 0; i < key.length(); ++i) {
                    char c = key.charAt(i);
                    if (Character.isLetterOrDigit(c)) continue;
                    charCounts.put((int)c, charCounts.get((int)c) + 1L);
                }
            }
        }
        final char[] mostProbableChar = new char[]{'.'};
        charCounts.forEachKey(new TIntProcedure(){
            long count = -1L;

            public boolean execute(int ch) {
                long charCount = charCounts.get(ch);
                if (charCount > this.count) {
                    this.count = charCount;
                    mostProbableChar[0] = (char)ch;
                }
                return true;
            }
        });
        if (mostProbableChar[0] == '\u0000') {
            mostProbableChar[0] = 46;
        }
        return Character.toString(mostProbableChar[0]);
    }

    public void setSeparator(VirtualFile file, String separator) {
        this.mySeparators.put(file, separator);
    }

    public void loadState(Element element) {
        List files = element.getChildren(FILE_ELEMENT);
        for (Element fileElement : files) {
            ResourceBundle resourceBundle;
            VirtualFile file;
            String url = fileElement.getAttributeValue(URL_ELEMENT, "");
            String separator = fileElement.getAttributeValue(SEPARATOR_ATTR, "");
            if ((separator = PropertiesSeparatorManager.decodeSeparator(separator)) == null || (file = (resourceBundle = ResourceBundleImpl.createByUrl(url)) != null ? new ResourceBundleAsVirtualFile(resourceBundle) : VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
            this.mySeparators.put(file, separator);
        }
    }

    @Nullable
    private static String decodeSeparator(String separator) {
        if (separator.length() % 6 != 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int pos = 0; pos < separator.length(); pos += 6) {
            String encodedCharacter = separator.substring(pos, pos + 6);
            if (!encodedCharacter.startsWith("\\u")) {
                return null;
            }
            int d1 = Character.digit(encodedCharacter.charAt(2), 16);
            int d2 = Character.digit(encodedCharacter.charAt(3), 16);
            int d3 = Character.digit(encodedCharacter.charAt(4), 16);
            int d4 = Character.digit(encodedCharacter.charAt(5), 16);
            if (d1 == -1 || d2 == -1 || d3 == -1 || d4 == -1) {
                return null;
            }
            int b1 = d1 << 12 & 0xF000;
            int b2 = d2 << 8 & 0xF00;
            int b3 = d3 << 4 & 0xF0;
            int b4 = d4 << 0 & 0xF;
            char code = (char)(b1 | b2 | b3 | b4);
            result.append(code);
        }
        return result.toString();
    }

    public Element getState() {
        Element element = new Element("PropertiesSeparatorManager");
        for (VirtualFile file : this.mySeparators.keySet()) {
            String url;
            if (file instanceof ResourceBundleAsVirtualFile) {
                ResourceBundle resourceBundle = ((ResourceBundleAsVirtualFile)file).getResourceBundle();
                url = ((ResourceBundleImpl)resourceBundle).getUrl();
            } else {
                url = file.getUrl();
            }
            String separator = this.mySeparators.get(file);
            StringBuilder encoded = new StringBuilder(separator.length());
            for (int i = 0; i < separator.length(); ++i) {
                char c = separator.charAt(i);
                encoded.append("\\u");
                encoded.append(Character.forDigit(c >> 12, 16));
                encoded.append(Character.forDigit(c >> 8 & 0xF, 16));
                encoded.append(Character.forDigit(c >> 4 & 0xF, 16));
                encoded.append(Character.forDigit(c & 0xF, 16));
            }
            Element fileElement = new Element(FILE_ELEMENT);
            fileElement.setAttribute(URL_ELEMENT, url);
            fileElement.setAttribute(SEPARATOR_ATTR, encoded.toString());
            element.addContent(fileElement);
        }
        return element;
    }
}

