/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.structureView.PropertiesStructureViewElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PropertiesPrefixGroup
implements Group {
    private final Collection<TreeElement> myProperties;
    @NotNull
    private final String myPrefix;
    private final String myPresentableName;
    @NotNull
    private final String mySeparator;

    public PropertiesPrefixGroup(Collection<TreeElement> properties, String prefix, String presentableName, String separator) {
        this.myProperties = properties;
        this.myPrefix = prefix;
        this.myPresentableName = presentableName;
        this.mySeparator = separator;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation = new ItemPresentation(){

            public String getPresentableText() {
                return PropertiesPrefixGroup.this.myPresentableName;
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return AllIcons.Nodes.Advice;
            }
        };
        if (itemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesPrefixGroup", "getPresentation"));
        }
        return itemPresentation;
    }

    @NotNull
    public Collection<TreeElement> getChildren() {
        ArrayList<TreeElement> result = new ArrayList<TreeElement>();
        List prefixWords = StringUtil.split((String)this.myPrefix, (String)this.mySeparator);
        for (TreeElement treeElement : this.myProperties) {
            boolean startsWith;
            String key;
            if (treeElement instanceof PropertiesStructureViewElement) {
                PropertiesStructureViewElement propertiesElement = (PropertiesStructureViewElement)treeElement;
                Property property = propertiesElement.getValue();
                key = property.getUnescapedKey();
            } else {
                if (!(treeElement instanceof ResourceBundlePropertyStructureViewElement)) continue;
                key = ((ResourceBundlePropertyStructureViewElement)treeElement).getValue();
            }
            if (key == null || key.equals(this.myPrefix)) continue;
            List keyWords = StringUtil.split((String)key, (String)this.mySeparator);
            boolean bl = startsWith = prefixWords.size() < keyWords.size();
            if (startsWith) {
                for (int i = 0; i < prefixWords.size(); ++i) {
                    String prefixWord = (String)prefixWords.get(i);
                    String keyWord = (String)keyWords.get(i);
                    if (Comparing.strEqual((String)keyWord, (String)prefixWord)) continue;
                    startsWith = false;
                    break;
                }
            }
            if (!startsWith) continue;
            result.add(treeElement);
            String presentableName = key.substring(this.myPrefix.length());
            presentableName = StringUtil.trimStart((String)presentableName, (String)this.mySeparator);
            if (treeElement instanceof PropertiesStructureViewElement) {
                ((PropertiesStructureViewElement)treeElement).setPresentableName(presentableName);
            }
            if (!(treeElement instanceof ResourceBundlePropertyStructureViewElement)) continue;
            ((ResourceBundlePropertyStructureViewElement)treeElement).setPresentableName(presentableName);
        }
        ArrayList<TreeElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/structureView/PropertiesPrefixGroup", "getChildren"));
        }
        return arrayList;
    }

    public String getPrefix() {
        return this.myPrefix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesPrefixGroup group = (PropertiesPrefixGroup)o;
        return this.myPrefix.equals(group.myPrefix);
    }

    public int hashCode() {
        return this.myPrefix.hashCode();
    }
}

