/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.refactoring;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.refactoring.PropertiesRefactoringSettings;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.usageView.UsageInfo;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RenamePropertyProcessor
extends RenamePsiElementProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/refactoring/RenamePropertyProcessor", "canProcessElement"));
        }
        return element instanceof IProperty;
    }

    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        IProperty property = (IProperty)element;
        ResourceBundle resourceBundle = property.getPropertiesFile().getResourceBundle();
        List<IProperty> properties = PropertiesUtil.findAllProperties(element.getProject(), resourceBundle, property.getUnescapedKey());
        allRenames.clear();
        for (IProperty otherProperty : properties) {
            allRenames.put(otherProperty.getPsiElement(), newName);
        }
    }

    public void findCollisions(PsiElement element, final String newName, Map<? extends PsiElement, String> allRenames, List<UsageInfo> result) {
        for (IProperty property : ((PropertiesFile)element.getContainingFile()).getProperties()) {
            if (!Comparing.strEqual((String)newName, (String)property.getKey())) continue;
            result.add((UsageInfo)new UnresolvableCollisionUsageInfo(property.getPsiElement(), element){

                public String getDescription() {
                    return "New property name '" + newName + "' hides existing property";
                }
            });
        }
    }

    public boolean isToSearchInComments(PsiElement element) {
        return PropertiesRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        PropertiesRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS = enabled;
    }
}

