/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleMoveProvider
extends MoveHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)("#" + ResourceBundleMoveProvider.class.getName()));

    public boolean canMove(DataContext dataContext) {
        return ResourceBundle.ARRAY_DATA_KEY.getData(dataContext) != null;
    }

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer) {
        return false;
    }

    public boolean isValidTarget(PsiElement psiElement, PsiElement[] sources) {
        return MoveFilesOrDirectoriesHandler.isValidTarget((PsiElement)psiElement);
    }

    public void collectFilesOrDirsFromContext(DataContext dataContext, Set<PsiElement> filesOrDirs) {
        ResourceBundle[] bundles = (ResourceBundle[])ResourceBundle.ARRAY_DATA_KEY.getData(dataContext);
        LOG.assertTrue(bundles != null);
        for (ResourceBundle bundle : bundles) {
            List<PropertiesFile> propertiesFiles = bundle.getPropertiesFiles((Project)CommonDataKeys.PROJECT.getData(dataContext));
            for (PropertiesFile propertiesFile : propertiesFiles) {
                filesOrDirs.add((PsiElement)propertiesFile.getContainingFile());
            }
        }
    }

    public boolean isMoveRedundant(PsiElement source, PsiElement target) {
        if (source instanceof PropertiesFile && target instanceof PsiDirectory) {
            return source.getParent() == target;
        }
        return super.isMoveRedundant(source, target);
    }
}

