/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.projectView;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.projectView.ResourceBundleDeleteProvider;
import com.intellij.lang.properties.projectView.ResourceBundleNode;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleGrouper
implements TreeStructureProvider,
DumbAware {
    private final Project myProject;

    public ResourceBundleGrouper(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, final @NotNull Collection<AbstractTreeNode> children, final ViewSettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/projectView/ResourceBundleGrouper", "modify"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/projectView/ResourceBundleGrouper", "modify"));
        }
        if (parent instanceof ResourceBundleNode) {
            Collection<AbstractTreeNode> collection = children;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/projectView/ResourceBundleGrouper", "modify"));
            }
            return collection;
        }
        Collection collection = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<AbstractTreeNode>>(){

            public Collection<AbstractTreeNode> compute() {
                THashMap childBundles = new THashMap();
                for (AbstractTreeNode child : children) {
                    PropertiesFile propertiesFile;
                    Object f = child.getValue();
                    if (!(f instanceof PsiFile) || (propertiesFile = PropertiesUtil.getPropertiesFile((PsiFile)f)) == null) continue;
                    ResourceBundle bundle = propertiesFile.getResourceBundle();
                    Collection files = (Collection)childBundles.get(bundle);
                    if (files == null) {
                        files = new SmartList();
                        childBundles.put(bundle, files);
                    }
                    files.add(propertiesFile);
                }
                ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
                for (Map.Entry entry : childBundles.entrySet()) {
                    ResourceBundle resourceBundle = (ResourceBundle)entry.getKey();
                    Collection files = (Collection)entry.getValue();
                    if (files.size() == 1) continue;
                    result.add((AbstractTreeNode)new ResourceBundleNode(ResourceBundleGrouper.this.myProject, resourceBundle, settings));
                }
                for (AbstractTreeNode child : children) {
                    ResourceBundle bundle;
                    PropertiesFile propertiesFile;
                    Object f = child.getValue();
                    if (f instanceof PsiFile && (propertiesFile = PropertiesUtil.getPropertiesFile((PsiFile)f)) != null && ((Collection)childBundles.get(bundle = propertiesFile.getResourceBundle())).size() != 1) continue;
                    result.add(child);
                }
                return result;
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/projectView/ResourceBundleGrouper", "modify"));
        }
        return collection;
    }

    public Object getData(Collection<AbstractTreeNode> selected, String dataName) {
        if (selected == null) {
            return null;
        }
        for (AbstractTreeNode selectedElement : selected) {
            Object element = selectedElement.getValue();
            if (!PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataName) || !(element instanceof ResourceBundle)) continue;
            return new ResourceBundleDeleteProvider((ResourceBundle)element);
        }
        if (ResourceBundle.ARRAY_DATA_KEY.is(dataName)) {
            ArrayList<ResourceBundle> selectedElements = new ArrayList<ResourceBundle>();
            for (AbstractTreeNode node : selected) {
                Object value = node.getValue();
                if (!(value instanceof ResourceBundle)) continue;
                selectedElements.add((ResourceBundle)value);
            }
            return selectedElements.isEmpty() ? null : selectedElements.toArray(new ResourceBundle[selectedElements.size()]);
        }
        return null;
    }
}

