/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import gnu.trove.TIntHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleUtil {
    private static final TIntHashSet SYMBOLS_TO_ESCAPE = new TIntHashSet(new int[]{35, 33, 61, 58});
    private static final char ESCAPE_SYMBOL = '\\';

    private ResourceBundleUtil() {
    }

    @Nullable
    public static ResourceBundle getResourceBundleFromDataContext(@NotNull DataContext dataContext) {
        PsiFile psiFile;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleUtil", "getResourceBundleFromDataContext"));
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (element instanceof IProperty) {
            return null;
        }
        ResourceBundle[] bundles = (ResourceBundle[])ResourceBundle.ARRAY_DATA_KEY.getData(dataContext);
        if (bundles != null && bundles.length == 1) {
            return bundles[0];
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (virtualFile == null) {
            return null;
        }
        if (virtualFile instanceof ResourceBundleAsVirtualFile) {
            return ((ResourceBundleAsVirtualFile)virtualFile).getResourceBundle();
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project != null && (psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) instanceof PropertiesFile) {
            return ((PropertiesFile)psiFile).getResourceBundle();
        }
        return null;
    }

    @Nullable
    public static ResourceBundleEditor getEditor(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleUtil", "getEditor"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (virtualFile == null) {
            return null;
        }
        FileEditor[] editors = FileEditorManager.getInstance((Project)project).getEditors(virtualFile);
        if (editors.length != 1 || !(editors[0] instanceof ResourceBundleEditor)) {
            return null;
        }
        return (ResourceBundleEditor)editors[0];
    }

    @NotNull
    public static String fromPropertyValueToValueEditor(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleUtil", "fromPropertyValueToValueEditor"));
        }
        StringBuilder buffer = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\' && !escaped && (i == text.length() - 1 || text.charAt(i + 1) != 'u' && text.charAt(i + 1) != 'U')) {
                escaped = true;
                continue;
            }
            if (escaped && c == 'n') {
                buffer.append('\\');
            }
            buffer.append(c);
            escaped = false;
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleUtil", "fromPropertyValueToValueEditor"));
        }
        return string;
    }

    @NotNull
    public static String fromValueEditorToPropertyValue(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleUtil", "fromValueEditorToPropertyValue"));
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (i == 0 && (c == ' ' || c == '\t') || c == '\n' || SYMBOLS_TO_ESCAPE.contains((int)c)) {
                buffer.append('\\');
            } else if (c == '\\') {
                if (text.length() > i + 1) {
                    char nextChar = text.charAt(i + 1);
                    if (nextChar != 'n' && nextChar != 'u' && nextChar != 'U') {
                        buffer.append('\\');
                    }
                } else {
                    buffer.append('\\');
                }
            }
            buffer.append(c);
        }
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleUtil", "fromValueEditorToPropertyValue"));
        }
        return string;
    }
}

