/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.PropertiesGroupingStructureViewModel;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleFileStructureViewElement;
import com.intellij.lang.properties.structureView.GroupByWordPrefixes;
import com.intellij.lang.properties.structureView.PropertiesSeparatorManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleStructureViewModel
implements PropertiesGroupingStructureViewModel {
    private final Project myProject;
    private final ResourceBundle myResourceBundle;
    private final GroupByWordPrefixes myGroupByWordPrefixes;

    public ResourceBundleStructureViewModel(Project project, ResourceBundle root) {
        this.myProject = project;
        this.myResourceBundle = root;
        String separator = PropertiesSeparatorManager.getInstance().getSeparator(project, new ResourceBundleAsVirtualFile(this.myResourceBundle));
        this.myGroupByWordPrefixes = new GroupByWordPrefixes(separator);
    }

    @Override
    public void setSeparator(String separator) {
        this.myGroupByWordPrefixes.setSeparator(separator);
        PropertiesSeparatorManager.getInstance().setSeparator(new ResourceBundleAsVirtualFile(this.myResourceBundle), separator);
    }

    @Override
    public String getSeparator() {
        return this.myGroupByWordPrefixes.getSeparator();
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        ResourceBundleFileStructureViewElement resourceBundleFileStructureViewElement = new ResourceBundleFileStructureViewElement(this.myProject, this.myResourceBundle);
        if (resourceBundleFileStructureViewElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "getRoot"));
        }
        return resourceBundleFileStructureViewElement;
    }

    @NotNull
    public Grouper[] getGroupers() {
        Grouper[] grouperArray = new Grouper[]{this.myGroupByWordPrefixes};
        if (grouperArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "getGroupers"));
        }
        return grouperArray;
    }

    @NotNull
    public Sorter[] getSorters() {
        Sorter[] sorterArray = new Sorter[]{Sorter.ALPHA_SORTER};
        if (sorterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "getSorters"));
        }
        return sorterArray;
    }

    @NotNull
    public Filter[] getFilters() {
        if (Filter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "getFilters"));
        }
        return Filter.EMPTY_ARRAY;
    }

    public Object getCurrentEditorElement() {
        return null;
    }

    public void addEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "addEditorPositionListener"));
        }
    }

    public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "removeEditorPositionListener"));
        }
    }

    public void addModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "addModelListener"));
        }
    }

    public void removeModelListener(@NotNull ModelListener modelListener) {
        if (modelListener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/editor/ResourceBundleStructureViewModel", "removeModelListener"));
        }
    }

    public void dispose() {
    }

    public boolean shouldEnterElement(Object element) {
        return false;
    }
}

