/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleFileStructureViewElement
implements StructureViewTreeElement {
    private final Project myProject;
    private final ResourceBundle myResourceBundle;

    public ResourceBundleFileStructureViewElement(Project project, ResourceBundle resourceBundle) {
        this.myProject = project;
        this.myResourceBundle = resourceBundle;
    }

    public ResourceBundle getValue() {
        return this.myResourceBundle;
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        List<PropertiesFile> propertiesFiles = this.myResourceBundle.getPropertiesFiles(this.myProject);
        LinkedHashMap<String, IProperty> propertyNames = new LinkedHashMap<String, IProperty>();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            List<IProperty> properties = propertiesFile.getProperties();
            for (IProperty property : properties) {
                String name = property.getUnescapedKey();
                if (propertyNames.containsKey(name)) continue;
                propertyNames.put(name, property);
            }
        }
        ArrayList<ResourceBundlePropertyStructureViewElement> result = new ArrayList<ResourceBundlePropertyStructureViewElement>(propertyNames.size());
        for (String property : propertyNames.keySet()) {
            result.add(new ResourceBundlePropertyStructureViewElement(this.myProject, this.myResourceBundle, property));
        }
        StructureViewTreeElement[] structureViewTreeElementArray = result.toArray(new StructureViewTreeElement[result.size()]);
        if (structureViewTreeElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleFileStructureViewElement", "getChildren"));
        }
        return structureViewTreeElementArray;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation = new ItemPresentation(){

            public String getPresentableText() {
                return ResourceBundleFileStructureViewElement.this.myResourceBundle.getBaseName();
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return AllIcons.FileTypes.Properties;
            }
        };
        if (itemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleFileStructureViewElement", "getPresentation"));
        }
        return itemPresentation;
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }
}

