/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleImpl
implements ResourceBundle {
    @NotNull
    private final VirtualFile myBaseDirectory;
    @NotNull
    private final String myBaseName;
    @NonNls
    private static final String RESOURCE_BUNDLE_PREFIX = "resourceBundle:";
    public static final ResourceBundle NULL = new ResourceBundle(){

        @Override
        @NotNull
        public List<PropertiesFile> getPropertiesFiles(Project project) {
            List<PropertiesFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleImpl$1", "getPropertiesFiles"));
            }
            return list;
        }

        @Override
        @NotNull
        public PropertiesFile getDefaultPropertiesFile(Project project) {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public String getBaseName() {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleImpl$1", "getBaseName"));
            }
            return "";
        }

        @Override
        @NotNull
        public VirtualFile getBaseDirectory() {
            throw new IllegalStateException();
        }
    };

    public ResourceBundleImpl(@NotNull VirtualFile baseDirectory, @NotNull String baseName) {
        if (baseDirectory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/lang/properties/ResourceBundleImpl", "<init>"));
        }
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/lang/properties/ResourceBundleImpl", "<init>"));
        }
        this.myBaseDirectory = baseDirectory;
        this.myBaseName = baseName;
    }

    @Override
    @NotNull
    public List<PropertiesFile> getPropertiesFiles(Project project) {
        VirtualFile[] children = this.myBaseDirectory.getChildren();
        SmartList result = new SmartList();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : children) {
            PropertiesFile propertiesFile;
            if (!file.isValid() || !Comparing.strEqual((String)PropertiesUtil.getBaseName(file), (String)this.myBaseName) || (propertiesFile = PropertiesUtil.getPropertiesFile(psiManager.findFile(file))) == null) continue;
            result.add(propertiesFile);
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleImpl", "getPropertiesFiles"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public PropertiesFile getDefaultPropertiesFile(Project project) {
        List<PropertiesFile> files = this.getPropertiesFiles(project);
        ContainerUtil.quickSort(files, (Comparator)new Comparator<PropertiesFile>(){

            @Override
            public int compare(PropertiesFile o1, PropertiesFile o2) {
                return Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
            }
        });
        PropertiesFile propertiesFile = files.get(0);
        if (propertiesFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleImpl", "getDefaultPropertiesFile"));
        }
        return propertiesFile;
    }

    @Override
    @NotNull
    public String getBaseName() {
        String string = this.myBaseName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleImpl", "getBaseName"));
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceBundleImpl resourceBundle = (ResourceBundleImpl)o;
        if (!this.myBaseDirectory.equals(resourceBundle.myBaseDirectory)) {
            return false;
        }
        return this.myBaseName.equals(resourceBundle.myBaseName);
    }

    public int hashCode() {
        int result = this.myBaseDirectory.hashCode();
        result = 29 * result + this.myBaseName.hashCode();
        return result;
    }

    @Nullable
    public static ResourceBundle createByUrl(String url) {
        if (!url.startsWith(RESOURCE_BUNDLE_PREFIX)) {
            return null;
        }
        String defaultPropertiesUrl = url.substring(RESOURCE_BUNDLE_PREFIX.length());
        int idx = defaultPropertiesUrl.lastIndexOf(47);
        if (idx == -1) {
            return null;
        }
        String baseDir = defaultPropertiesUrl.substring(0, idx);
        String baseName = defaultPropertiesUrl.substring(idx + 1);
        VirtualFile baseDirectory = VirtualFileManager.getInstance().findFileByUrl(baseDir);
        if (baseDirectory != null) {
            return new ResourceBundleImpl(baseDirectory, baseName);
        }
        return null;
    }

    public String getUrl() {
        return RESOURCE_BUNDLE_PREFIX + this.getBaseDirectory() + "/" + this.getBaseName();
    }

    @Override
    @NotNull
    public VirtualFile getBaseDirectory() {
        VirtualFile virtualFile = this.myBaseDirectory;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleImpl", "getBaseDirectory"));
        }
        return virtualFile;
    }
}

