/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicatePropertyInspection;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class DuplicatePropertyInspection
extends GlobalSimpleInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.DuplicatePropertyInspection");
    public boolean CURRENT_FILE = true;
    public boolean MODULE_WITH_DEPENDENCIES = false;
    public boolean CHECK_DUPLICATE_VALUES = true;
    public boolean CHECK_DUPLICATE_KEYS = true;
    public boolean CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES = true;

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/duplicatePropertyInspection/DuplicatePropertyInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/duplicatePropertyInspection/DuplicatePropertyInspection", "checkFile"));
        }
        if (problemsHolder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/duplicatePropertyInspection/DuplicatePropertyInspection", "checkFile"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/duplicatePropertyInspection/DuplicatePropertyInspection", "checkFile"));
        }
        if (problemDescriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInspection/duplicatePropertyInspection/DuplicatePropertyInspection", "checkFile"));
        }
        this.checkFile(file, manager, (GlobalInspectionContextImpl)globalContext, globalContext.getRefManager(), problemDescriptionsProcessor);
    }

    private static void surroundWithHref(StringBuffer anchor, PsiElement element, boolean isValue) {
        if (element != null) {
            PsiElement elementToLink;
            PsiElement parent = element.getParent();
            PsiElement psiElement = elementToLink = isValue ? parent.getFirstChild() : parent.getLastChild();
            if (elementToLink != null) {
                HTMLComposer.appendAfterHeaderIndention((StringBuffer)anchor);
                HTMLComposer.appendAfterHeaderIndention((StringBuffer)anchor);
                anchor.append("<a HREF=\"");
                try {
                    VirtualFile virtualFile;
                    PsiFile file = element.getContainingFile();
                    if (file != null && (virtualFile = file.getVirtualFile()) != null) {
                        anchor.append(new URL(virtualFile.getUrl() + "#" + elementToLink.getTextRange().getStartOffset()));
                    }
                }
                catch (MalformedURLException e) {
                    LOG.error((Throwable)e);
                }
                anchor.append("\">");
                anchor.append(elementToLink.getText().replaceAll("\\$", "\\\\\\$"));
                anchor.append("</a>");
                DuplicatePropertyInspection.compoundLineLink(anchor, element);
                anchor.append("<br>");
            }
        } else {
            anchor.append("<font style=\"font-family:verdana; font-weight:bold; color:#FF0000\";>");
            anchor.append(InspectionsBundle.message((String)"inspection.export.results.invalidated.item", (Object[])new Object[0]));
            anchor.append("</font>");
        }
    }

    private static void compoundLineLink(StringBuffer lineAnchor, PsiElement psiElement) {
        VirtualFile vFile;
        PsiFile file = psiElement.getContainingFile();
        if (file != null && (vFile = file.getVirtualFile()) != null) {
            Document doc = FileDocumentManager.getInstance().getDocument(vFile);
            int lineNumber = doc.getLineNumber(psiElement.getTextOffset()) + 1;
            lineAnchor.append(" ").append(InspectionsBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0])).append(" ");
            lineAnchor.append("<a HREF=\"");
            try {
                int offset = doc.getLineStartOffset(lineNumber - 1);
                offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)offset, (String)" \t");
                lineAnchor.append(new URL(vFile.getUrl() + "#" + offset));
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
            lineAnchor.append("\">");
            lineAnchor.append(Integer.toString(lineNumber));
            lineAnchor.append("</a>");
        }
    }

    private void checkFile(PsiFile file, InspectionManager manager, GlobalInspectionContextImpl context, RefManager refManager, ProblemDescriptionsProcessor processor) {
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        if (!context.isToCheckFile(file, (InspectionProfileEntry)this)) {
            return;
        }
        PsiSearchHelper searchHelper = PsiSearchHelper.SERVICE.getInstance((Project)file.getProject());
        PropertiesFile propertiesFile = (PropertiesFile)file;
        final List<IProperty> properties = propertiesFile.getProperties();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return;
        }
        GlobalSearchScope scope = this.CURRENT_FILE ? GlobalSearchScope.fileScope((PsiFile)file) : (this.MODULE_WITH_DEPENDENCIES ? GlobalSearchScope.moduleWithDependenciesScope((Module)module) : GlobalSearchScope.projectScope((Project)file.getProject()));
        Map processedValueToFiles = Collections.synchronizedMap(new HashMap());
        Map processedKeyToFiles = Collections.synchronizedMap(new HashMap());
        ProgressIndicator original = ProgressManager.getInstance().getProgressIndicator();
        ProgressWrapper progress = ProgressWrapper.wrap((ProgressIndicator)original);
        ProgressManager.getInstance().runProcess(new Runnable((ProgressIndicator)progress, original, processedValueToFiles, processedKeyToFiles, searchHelper, scope, manager, file, processor, refManager){
            final /* synthetic */ ProgressIndicator val$progress;
            final /* synthetic */ ProgressIndicator val$original;
            final /* synthetic */ Map val$processedValueToFiles;
            final /* synthetic */ Map val$processedKeyToFiles;
            final /* synthetic */ PsiSearchHelper val$searchHelper;
            final /* synthetic */ GlobalSearchScope val$scope;
            final /* synthetic */ InspectionManager val$manager;
            final /* synthetic */ PsiFile val$file;
            final /* synthetic */ ProblemDescriptionsProcessor val$processor;
            final /* synthetic */ RefManager val$refManager;
            {
                this.val$progress = progressIndicator;
                this.val$original = progressIndicator2;
                this.val$processedValueToFiles = map;
                this.val$processedKeyToFiles = map2;
                this.val$searchHelper = psiSearchHelper;
                this.val$scope = globalSearchScope;
                this.val$manager = inspectionManager;
                this.val$file = psiFile;
                this.val$processor = problemDescriptionsProcessor;
                this.val$refManager = refManager;
            }

            @Override
            public void run() {
                if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(properties, this.val$progress, false, (Processor)new Processor<IProperty>(){

                    public boolean process(IProperty property) {
                        if (val$original != null) {
                            if (val$original.isCanceled()) {
                                return false;
                            }
                            val$original.setText2(PropertiesBundle.message("searching.for.property.key.progress.text", property.getUnescapedKey()));
                        }
                        DuplicatePropertyInspection.processTextUsages(val$processedValueToFiles, property.getValue(), val$processedKeyToFiles, val$searchHelper, val$scope);
                        DuplicatePropertyInspection.processTextUsages(val$processedKeyToFiles, property.getUnescapedKey(), val$processedValueToFiles, val$searchHelper, val$scope);
                        return true;
                    }
                })) {
                    throw new ProcessCanceledException();
                }
                ArrayList problemDescriptors = new ArrayList();
                HashMap keyToDifferentValues = new HashMap();
                if (DuplicatePropertyInspection.this.CHECK_DUPLICATE_KEYS || DuplicatePropertyInspection.this.CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES) {
                    DuplicatePropertyInspection.this.prepareDuplicateKeysByFile(this.val$processedKeyToFiles, this.val$manager, keyToDifferentValues, problemDescriptors, this.val$file, this.val$original);
                }
                if (DuplicatePropertyInspection.this.CHECK_DUPLICATE_VALUES) {
                    DuplicatePropertyInspection.prepareDuplicateValuesByFile(this.val$processedValueToFiles, this.val$manager, problemDescriptors, this.val$file, this.val$original);
                }
                if (DuplicatePropertyInspection.this.CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES) {
                    DuplicatePropertyInspection.processDuplicateKeysWithDifferentValues(keyToDifferentValues, this.val$processedKeyToFiles, problemDescriptors, this.val$manager, this.val$file, this.val$original);
                }
                if (!problemDescriptors.isEmpty()) {
                    this.val$processor.addProblemElement((RefEntity)this.val$refManager.getReference((PsiElement)this.val$file), (CommonProblemDescriptor[])problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]));
                }
            }
        }, (ProgressIndicator)progress);
    }

    private static void processTextUsages(Map<String, Set<PsiFile>> processedTextToFiles, String text, Map<String, Set<PsiFile>> processedFoundTextToFiles, PsiSearchHelper searchHelper, GlobalSearchScope scope) {
        if (!processedTextToFiles.containsKey(text)) {
            if (processedFoundTextToFiles.containsKey(text)) {
                Set<PsiFile> filesWithValue = processedFoundTextToFiles.get(text);
                processedTextToFiles.put(text, filesWithValue);
            } else {
                HashSet<PsiFile> resultFiles = new HashSet<PsiFile>();
                DuplicatePropertyInspection.findFilesWithText(text, searchHelper, scope, resultFiles);
                if (resultFiles.isEmpty()) {
                    return;
                }
                processedTextToFiles.put(text, resultFiles);
            }
        }
    }

    private static void prepareDuplicateValuesByFile(Map<String, Set<PsiFile>> valueToFiles, InspectionManager manager, List<ProblemDescriptor> problemDescriptors, PsiFile psiFile, ProgressIndicator progress) {
        for (String value : valueToFiles.keySet()) {
            if (progress != null) {
                progress.setText2(InspectionsBundle.message((String)"duplicate.property.value.progress.indicator.text", (Object[])new Object[]{value}));
                progress.checkCanceled();
            }
            if (value.length() == 0) continue;
            StringSearcher searcher = new StringSearcher(value, true, true);
            StringBuffer message = new StringBuffer();
            int duplicatesCount = 0;
            Set<PsiFile> psiFilesWithDuplicates = valueToFiles.get(value);
            for (PsiFile file : psiFilesWithDuplicates) {
                CharSequence text = file.getViewProvider().getContents();
                char[] textArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)text);
                int offset = LowLevelSearchUtil.searchWord((CharSequence)text, (char[])textArray, (int)0, (int)text.length(), (StringSearcher)searcher, (ProgressIndicator)progress);
                while (offset >= 0) {
                    Property property;
                    PsiElement element = file.findElementAt(offset);
                    if (element != null && element.getParent() instanceof Property && Comparing.equal((String)(property = (Property)element.getParent()).getValue(), (String)value) && element.getStartOffsetInParent() != 0) {
                        if (duplicatesCount == 0) {
                            message.append(InspectionsBundle.message((String)"duplicate.property.value.problem.descriptor", (Object[])new Object[]{property.getValue()}));
                        }
                        DuplicatePropertyInspection.surroundWithHref(message, element, true);
                        ++duplicatesCount;
                    }
                    offset = LowLevelSearchUtil.searchWord((CharSequence)text, (char[])textArray, (int)(offset + searcher.getPattern().length()), (int)text.length(), (StringSearcher)searcher, (ProgressIndicator)progress);
                }
            }
            if (duplicatesCount <= true) continue;
            problemDescriptors.add(manager.createProblemDescriptor((PsiElement)psiFile, message.toString(), false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    private void prepareDuplicateKeysByFile(Map<String, Set<PsiFile>> keyToFiles, InspectionManager manager, Map<String, Set<String>> keyToValues, List<ProblemDescriptor> problemDescriptors, PsiFile psiFile, ProgressIndicator progress) {
        for (String key : keyToFiles.keySet()) {
            if (progress != null) {
                progress.setText2(InspectionsBundle.message((String)"duplicate.property.key.progress.indicator.text", (Object[])new Object[]{key}));
                if (progress.isCanceled()) {
                    throw new ProcessCanceledException();
                }
            }
            StringBuffer message = new StringBuffer();
            int duplicatesCount = 0;
            Set<PsiFile> psiFilesWithDuplicates = keyToFiles.get(key);
            for (PsiFile file : psiFilesWithDuplicates) {
                if (!(file instanceof PropertiesFile)) continue;
                PropertiesFile propertiesFile = (PropertiesFile)file;
                List<IProperty> propertiesByKey = propertiesFile.findPropertiesByKey(key);
                for (IProperty property : propertiesByKey) {
                    if (duplicatesCount == 0) {
                        message.append(InspectionsBundle.message((String)"duplicate.property.key.problem.descriptor", (Object[])new Object[]{key}));
                    }
                    DuplicatePropertyInspection.surroundWithHref(message, property.getPsiElement().getFirstChild(), false);
                    ++duplicatesCount;
                    Set<String> values = keyToValues.get(key);
                    if (values == null) {
                        values = new HashSet<String>();
                        keyToValues.put(key, values);
                    }
                    values.add(property.getValue());
                }
            }
            if (duplicatesCount <= true || !this.CHECK_DUPLICATE_KEYS) continue;
            problemDescriptors.add(manager.createProblemDescriptor((PsiElement)psiFile, message.toString(), false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    private static void processDuplicateKeysWithDifferentValues(Map<String, Set<String>> keyToDifferentValues, Map<String, Set<PsiFile>> keyToFiles, List<ProblemDescriptor> problemDescriptors, InspectionManager manager, PsiFile psiFile, ProgressIndicator progress) {
        for (String key : keyToDifferentValues.keySet()) {
            Set<String> values;
            if (progress != null) {
                progress.setText2(InspectionsBundle.message((String)"duplicate.property.diff.key.progress.indicator.text", (Object[])new Object[]{key}));
                if (progress.isCanceled()) {
                    throw new ProcessCanceledException();
                }
            }
            if ((values = keyToDifferentValues.get(key)) == null || values.size() < 2) {
                keyToFiles.remove(key);
                continue;
            }
            StringBuffer message = new StringBuffer();
            Set<PsiFile> psiFiles = keyToFiles.get(key);
            boolean firstUsage = true;
            for (PsiFile file : psiFiles) {
                if (!(file instanceof PropertiesFile)) continue;
                PropertiesFile propertiesFile = (PropertiesFile)file;
                List<IProperty> propertiesByKey = propertiesFile.findPropertiesByKey(key);
                for (IProperty property : propertiesByKey) {
                    if (firstUsage) {
                        message.append(InspectionsBundle.message((String)"duplicate.property.diff.key.problem.descriptor", (Object[])new Object[]{key}));
                        firstUsage = false;
                    }
                    DuplicatePropertyInspection.surroundWithHref(message, property.getPsiElement().getFirstChild(), false);
                }
            }
            problemDescriptors.add(manager.createProblemDescriptor((PsiElement)psiFile, message.toString(), false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    private static void findFilesWithText(String stringToFind, PsiSearchHelper searchHelper, GlobalSearchScope scope, Set<PsiFile> resultFiles) {
        List words = StringUtil.getWordsIn((String)stringToFind);
        if (words.isEmpty()) {
            return;
        }
        Collections.sort(words, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        for (String word : words) {
            THashSet files = new THashSet();
            searchHelper.processAllFilesWithWord(word, scope, (Processor)new CommonProcessors.CollectProcessor((Collection)files), true);
            if (resultFiles.isEmpty()) {
                resultFiles.addAll((Collection<PsiFile>)files);
            } else {
                resultFiles.retainAll((Collection<?>)files);
            }
            if (!resultFiles.isEmpty()) continue;
            return;
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"duplicate.property.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicatePropertyInspection/DuplicatePropertyInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.properties.files", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicatePropertyInspection/DuplicatePropertyInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("DuplicatePropertyInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/duplicatePropertyInspection/DuplicatePropertyInspection", "getShortName"));
        }
        return "DuplicatePropertyInspection";
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().myWholePanel;
    }

    public class OptionsPanel {
        private JRadioButton myFileScope;
        private JRadioButton myModuleScope;
        private JRadioButton myProjectScope;
        private JCheckBox myDuplicateValues;
        private JCheckBox myDuplicateKeys;
        private JCheckBox myDuplicateBoth;
        private JPanel myWholePanel;

        OptionsPanel() {
            this.$$$setupUI$$$();
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.myFileScope);
            buttonGroup.add(this.myModuleScope);
            buttonGroup.add(this.myProjectScope);
            this.myFileScope.setSelected(DuplicatePropertyInspection.this.CURRENT_FILE);
            this.myModuleScope.setSelected(DuplicatePropertyInspection.this.MODULE_WITH_DEPENDENCIES);
            this.myProjectScope.setSelected(!DuplicatePropertyInspection.this.CURRENT_FILE && !DuplicatePropertyInspection.this.MODULE_WITH_DEPENDENCIES);
            this.myFileScope.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DuplicatePropertyInspection.this.CURRENT_FILE = OptionsPanel.this.myFileScope.isSelected();
                }
            });
            this.myModuleScope.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DuplicatePropertyInspection.this.MODULE_WITH_DEPENDENCIES = OptionsPanel.this.myModuleScope.isSelected();
                    if (DuplicatePropertyInspection.this.MODULE_WITH_DEPENDENCIES) {
                        DuplicatePropertyInspection.this.CURRENT_FILE = false;
                    }
                }
            });
            this.myProjectScope.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (OptionsPanel.this.myProjectScope.isSelected()) {
                        DuplicatePropertyInspection.this.CURRENT_FILE = false;
                        DuplicatePropertyInspection.this.MODULE_WITH_DEPENDENCIES = false;
                    }
                }
            });
            this.myDuplicateKeys.setSelected(DuplicatePropertyInspection.this.CHECK_DUPLICATE_KEYS);
            this.myDuplicateValues.setSelected(DuplicatePropertyInspection.this.CHECK_DUPLICATE_VALUES);
            this.myDuplicateBoth.setSelected(DuplicatePropertyInspection.this.CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES);
            this.myDuplicateKeys.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DuplicatePropertyInspection.this.CHECK_DUPLICATE_KEYS = OptionsPanel.this.myDuplicateKeys.isSelected();
                }
            });
            this.myDuplicateValues.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DuplicatePropertyInspection.this.CHECK_DUPLICATE_VALUES = OptionsPanel.this.myDuplicateValues.isSelected();
                }
            });
            this.myDuplicateBoth.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DuplicatePropertyInspection.this.CHECK_DUPLICATE_KEYS_WITH_DIFFERENT_VALUES = OptionsPanel.this.myDuplicateBoth.isSelected();
                }
            });
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JRadioButton jRadioButton;
            JRadioButton jRadioButton2;
            JRadioButton jRadioButton3;
            JPanel jPanel;
            this.myWholePanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myProjectScope = jRadioButton3 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("messages/InspectionsBundle").getString("duplicate.property.project.scope.option"));
            jPanel2.add((Component)jRadioButton3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myFileScope = jRadioButton2 = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/InspectionsBundle").getString("duplicate.property.file.scope.option"));
            jPanel2.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myModuleScope = jRadioButton = new JRadioButton();
            this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/InspectionsBundle").getString("duplicate.property.module.scope.option"));
            jPanel2.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(20, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myDuplicateKeys = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/InspectionsBundle").getString("duplicate.property.key.option"));
            jPanel3.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDuplicateValues = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/InspectionsBundle").getString("duplicate.property.value.option"));
            jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myDuplicateBoth = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/InspectionsBundle").getString("duplicate.property.diff.key.option"));
            jPanel3.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myWholePanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

