/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.soap;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.soap.JiraSoapTask;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JiraSoapApi
extends JiraRemoteApi {
    private static final Logger LOG = Logger.getInstance(JiraSoapApi.class);
    @NonNls
    private static final String RSS_SEARCH_PATH = "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml";
    public static final String RSS_ISSUE_PATH = "/si/jira.issueviews:issue-xml/";

    public JiraSoapApi(@NotNull JiraRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/jira/soap/JiraSoapApi", "<init>"));
        }
        super(repository);
    }

    @Override
    @NotNull
    public List<Task> findTasks(String query, int max) throws Exception {
        GetMethod method = new GetMethod(this.myRepository.getUrl() + RSS_SEARCH_PATH);
        method.setQueryString(new NameValuePair[]{new NameValuePair("tempMax", String.valueOf(max)), new NameValuePair("assignee", TaskUtil.encodeUrl((String)this.myRepository.getUsername())), new NameValuePair("reset", "true"), new NameValuePair("sorter/field", "updated"), new NameValuePair("sorter/order", "DESC"), new NameValuePair("pager/start", "0")});
        List<Task> list = this.processRSS(method);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/soap/JiraSoapApi", "findTasks"));
        }
        return list;
    }

    private List<Task> processRSS(@NotNull GetMethod method) throws Exception {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/jira/soap/JiraSoapApi", "processRSS"));
        }
        int code = this.myRepository.getHttpClient().executeMethod((HttpMethod)method);
        if (code != 200) {
            throw new Exception(TaskBundle.message((String)"failure.http.error", (Object[])new Object[]{code, method.getStatusText()}));
        }
        Element root = new SAXBuilder(false).build(method.getResponseBodyAsStream()).getRootElement();
        Element channel = root.getChild("channel");
        if (channel != null) {
            List children = channel.getChildren("item");
            LOG.debug("Total issues in JIRA RSS feed: " + children.size());
            return ContainerUtil.map((Collection)children, (Function)new Function<Element, Task>(){

                public Task fun(Element element) {
                    return new JiraSoapTask(element, (TaskRepository)JiraSoapApi.this.myRepository);
                }
            });
        }
        LOG.warn("JIRA channel not found");
        return ContainerUtil.emptyList();
    }

    @Override
    @Nullable
    public Task findTask(String key) throws Exception {
        try {
            List<Task> tasks = this.processRSS(new GetMethod(this.myRepository.getUrl() + RSS_ISSUE_PATH + key + '/' + key + ".xml"));
            return tasks.isEmpty() ? null : tasks.get(0);
        }
        catch (Exception e) {
            LOG.warn("Cannot get issue " + key + ": " + e.getMessage());
            return null;
        }
    }

    @Override
    @NotNull
    public final JiraRemoteApi.ApiType getType() {
        JiraRemoteApi.ApiType apiType = JiraRemoteApi.ApiType.SOAP;
        if (apiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/soap/JiraSoapApi", "getType"));
        }
        return apiType;
    }

    @Override
    public void setTaskState(Task task, TaskState state) throws Exception {
        throw new Exception(TaskBundle.message((String)"jira.failure.no.state.update", (Object[])new Object[0]));
    }

    @Override
    public void updateTimeSpend(LocalTask task, String timeSpent, String comment) throws Exception {
        throw new Exception(TaskBundle.message((String)"jira.failure.no.time.spent", (Object[])new Object[0]));
    }
}

