/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.rest.api2;

import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.jira.JiraRemoteApi;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.rest.JiraRestApi;
import com.intellij.tasks.jira.rest.api2.model.JiraIssueApi2;
import com.intellij.tasks.jira.rest.model.JiraIssue;
import com.intellij.tasks.jira.rest.model.JiraResponseWrapper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JiraRestApi2
extends JiraRestApi {
    private static final Logger LOG = Logger.getInstance(JiraIssueApi2.class);
    private static final Type ISSUES_WRAPPER_TYPE = new TypeToken<JiraResponseWrapper.Issues<JiraIssueApi2>>(){}.getType();

    public JiraRestApi2(JiraRepository repository) {
        super(repository);
    }

    @Override
    @NotNull
    protected GetMethod getMultipleIssuesSearchMethod(String jql, int max) {
        GetMethod method = super.getMultipleIssuesSearchMethod(jql, max);
        method.setQueryString(method.getQueryString() + "&fields=" + "id,key,summary,description,created,updated,duedate,resolutiondate,assignee,reporter,issuetype,comment,status");
        GetMethod getMethod = method;
        if (getMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/rest/api2/JiraRestApi2", "getMultipleIssuesSearchMethod"));
        }
        return getMethod;
    }

    @Override
    @NotNull
    protected List<JiraIssue> parseIssues(String response) {
        JiraResponseWrapper.Issues wrapper = (JiraResponseWrapper.Issues)JiraRepository.GSON.fromJson(response, ISSUES_WRAPPER_TYPE);
        ArrayList<JiraIssue> arrayList = new ArrayList<JiraIssue>(wrapper.getIssues());
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/rest/api2/JiraRestApi2", "parseIssues"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected GetMethod getSingleIssueSearchMethod(String key) {
        GetMethod method = super.getSingleIssueSearchMethod(key);
        String oldParams = method.getQueryString() == null ? "" : method.getQueryString();
        method.setQueryString(oldParams + "&fields=" + "id,key,summary,description,created,updated,duedate,resolutiondate,assignee,reporter,issuetype,comment,status");
        GetMethod getMethod = method;
        if (getMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/rest/api2/JiraRestApi2", "getSingleIssueSearchMethod"));
        }
        return getMethod;
    }

    @Override
    @Nullable
    protected JiraIssue parseIssue(String response) {
        return (JiraIssue)JiraRepository.GSON.fromJson(response, JiraIssueApi2.class);
    }

    @Override
    @Nullable
    protected String getRequestForStateTransition(@NotNull TaskState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/jira/rest/api2/JiraRestApi2", "getRequestForStateTransition"));
        }
        switch (state) {
            case IN_PROGRESS: {
                return "{\"transition\": {\"id\": \"4\"}}";
            }
            case RESOLVED: {
                return "{\"transition\": {\"id\": \"5\"}, \"fields\": {\"resolution\": {\"name\": \"Fixed\"}}}";
            }
            case REOPENED: {
                return "{\"transition\": {\"id\": \"3\"}}";
            }
        }
        return null;
    }

    @Override
    public void updateTimeSpend(LocalTask task, String timeSpent, String comment) throws Exception {
        LOG.debug(String.format("Time spend: %s, comment: %s", timeSpent, comment));
        PostMethod method = new PostMethod(this.myRepository.getRestUrl("issue", task.getId(), "worklog"));
        String request = StringUtil.isEmpty((String)comment) ? String.format("{\"timeSpent\" : \"" + timeSpent + "\"}", timeSpent) : String.format("{\"timeSpent\": \"%s\", \"comment\": \"%s\"}", timeSpent, StringUtil.escapeQuotes((String)comment));
        method.setRequestEntity(JiraRestApi2.createJsonEntity(request));
        this.myRepository.executeMethod((HttpMethod)method);
    }

    @Override
    @NotNull
    public JiraRemoteApi.ApiType getType() {
        JiraRemoteApi.ApiType apiType = JiraRemoteApi.ApiType.REST_2_0;
        if (apiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/rest/api2/JiraRestApi2", "getType"));
        }
        return apiType;
    }
}

