/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.jira.CachedIconLoader;
import icons.TasksIcons;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JiraTask
extends Task {
    protected final TaskRepository myRepository;

    protected JiraTask(@NotNull TaskRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/tasks/jira/JiraTask", "<init>"));
        }
        this.myRepository = repository;
    }

    @NotNull
    public abstract String getId();

    @NotNull
    public abstract String getSummary();

    public abstract String getDescription();

    @NotNull
    public abstract Comment[] getComments();

    @Nullable
    protected abstract String getIconUrl();

    @NotNull
    public abstract TaskType getType();

    public abstract TaskState getState();

    @Nullable
    public abstract Date getUpdated();

    public abstract Date getCreated();

    public final String getIssueUrl() {
        return this.myRepository.getUrl() + "/browse/" + this.getId();
    }

    @NotNull
    public final Icon getIcon() {
        Icon icon = this.getIconByUrl(this.getIconUrl());
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraTask", "getIcon"));
        }
        return icon;
    }

    @Nullable
    public final TaskRepository getRepository() {
        return this.myRepository;
    }

    public final boolean isClosed() {
        return this.getState() == TaskState.RESOLVED;
    }

    public final boolean isIssue() {
        return true;
    }

    @NotNull
    protected final Icon getIconByUrl(@Nullable String iconUrl) {
        if (StringUtil.isEmpty((String)iconUrl)) {
            Icon icon = TasksIcons.Jira;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraTask", "getIconByUrl"));
            }
            return icon;
        }
        Icon icon = this.isClosed() ? CachedIconLoader.getDisabledIcon(iconUrl) : CachedIconLoader.getIcon(iconUrl);
        Icon icon2 = icon != null ? icon : TasksIcons.Other;
        if (icon2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/jira/JiraTask", "getIconByUrl"));
        }
        return icon2;
    }

    @Nullable
    protected final TaskState getStateById(int id) {
        switch (id) {
            case 1: {
                return TaskState.OPEN;
            }
            case 3: {
                return TaskState.IN_PROGRESS;
            }
            case 4: {
                return TaskState.REOPENED;
            }
            case 5: 
            case 6: {
                return TaskState.RESOLVED;
            }
        }
        return null;
    }

    protected final TaskType getTypeByName(@Nullable String type) {
        if (type == null) {
            return TaskType.OTHER;
        }
        if ("Bug".equals(type)) {
            return TaskType.BUG;
        }
        if ("Exception".equals(type)) {
            return TaskType.EXCEPTION;
        }
        if ("New Feature".equals(type)) {
            return TaskType.FEATURE;
        }
        return TaskType.OTHER;
    }
}

