/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.Closeable;
import org.gradle.api.Transformer;
import org.gradle.internal.Factory;
import org.gradle.internal.Supplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Suppliers {
    public static <I extends Closeable> Supplier<I> ofQuietlyClosed(final Factory<I> factory) {
        return new Supplier<I>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <R> R supplyTo(Transformer<R, ? super I> transformer) {
                Closeable thing = (Closeable)factory.create();
                R r = transformer.transform(thing);
                return r;
                finally {
                    try {
                        thing.close();
                    }
                    catch (Exception ignore) {}
                }
            }
        };
    }

    public static <I> Supplier<I> of(final Factory<? extends I> factory) {
        return new Supplier<I>(){

            @Override
            public <R> R supplyTo(Transformer<R, ? super I> transformer) {
                Object value = factory.create();
                return transformer.transform(value);
            }
        };
    }

    public static <I, T> Supplier<T> wrap(final Supplier<? extends I> supplier, final Transformer<T, ? super I> suppliedTransformer) {
        return new Supplier<T>(){

            @Override
            public <R> R supplyTo(final Transformer<R, ? super T> transformer) {
                return supplier.supplyTo(new Transformer<R, I>(){

                    @Override
                    public R transform(I original) {
                        Object transformedSupplied = suppliedTransformer.transform(original);
                        return transformer.transform(transformedSupplied);
                    }
                });
            }
        };
    }
}

