/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.task;

import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.task.AbstractExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.ProjectConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.task.GradleTaskManagerExtension;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleTaskManager
extends AbstractExternalSystemTaskManager<GradleExecutionSettings>
implements ExternalSystemTaskManager<GradleExecutionSettings> {
    private final GradleExecutionHelper myHelper = new GradleExecutionHelper();

    public void executeTasks(@NotNull ExternalSystemTaskId id, @NotNull List<String> taskNames, @NotNull String projectPath, @Nullable GradleExecutionSettings settings, @Nullable String vmOptions, @Nullable String debuggerSetup, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        throw new UnsupportedOperationException();
    }

    public void executeTasks(final @NotNull ExternalSystemTaskId id, final @NotNull List<String> taskNames, @NotNull String projectPath, final @Nullable GradleExecutionSettings settings, final @NotNull List<String> vmOptions, final @NotNull List<String> scriptParameters, final @Nullable String debuggerSetup, final @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (taskNames == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (vmOptions == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (scriptParameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "7", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "executeTasks"));
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.executeTasks(id, taskNames, projectPath, settings, vmOptions, scriptParameters, debuggerSetup, listener)) continue;
                return;
            }
        }
        Function<ProjectConnection, Void> f = new Function<ProjectConnection, Void>(){

            public Void fun(ProjectConnection connection) {
                if (!StringUtil.isEmpty((String)debuggerSetup)) {
                    try {
                        File tempFile = FileUtil.createTempFile((String)"init", (String)".gradle");
                        tempFile.deleteOnExit();
                        String[] lines = new String[]{"gradle.taskGraph.beforeTask { Task task ->", "    if (task instanceof JavaForkOptions) {", "        task.jvmArgs '" + debuggerSetup.trim() + '\'', "}}"};
                        FileUtil.writeToFile((File)tempFile, (String)StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator()));
                        ContainerUtil.addAll((Collection)scriptParameters, (Object[])new String[]{"--init-script", tempFile.getAbsolutePath()});
                    }
                    catch (IOException e) {
                        throw new ExternalSystemException((Throwable)e);
                    }
                }
                BuildLauncher launcher = GradleTaskManager.this.myHelper.getBuildLauncher(id, connection, settings, listener, vmOptions, scriptParameters);
                launcher.forTasks(ArrayUtil.toStringArray((Collection)taskNames));
                launcher.run();
                return null;
            }
        };
        this.myHelper.execute(projectPath, settings, f);
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "cancelTask"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/task/GradleTaskManager", "cancelTask"));
        }
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            for (GradleTaskManagerExtension gradleTaskManagerExtension : (GradleTaskManagerExtension[])GradleTaskManagerExtension.EP_NAME.getExtensions()) {
                if (!gradleTaskManagerExtension.cancelTask(id, listener)) continue;
                return true;
            }
        }
        if (!ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            listener.onStatusChange(new ExternalSystemTaskNotificationEvent(id, "Cancelling the task...\n"));
            System.exit(0);
        }
        return false;
    }
}

