/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.resolve.GradleMethodContextContributor;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceExpressionImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;

public class GradleArtifactsContributor
implements GradleMethodContextContributor {
    @Override
    public void process(@NotNull List<String> methodCallInfo, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (methodCallInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/resolve/GradleArtifactsContributor", "process"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/resolve/GradleArtifactsContributor", "process"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/gradle/service/resolve/GradleArtifactsContributor", "process"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/gradle/service/resolve/GradleArtifactsContributor", "process"));
        }
        if (methodCallInfo.isEmpty() || methodCallInfo.size() < 2 || !"artifacts".equals(methodCallInfo.get(1))) {
            return;
        }
        String text = place.getText();
        if (!methodCallInfo.contains(text) && place instanceof GrReferenceExpressionImpl) {
            GradleResolverUtil.addImplicitVariable(processor, state, (GrReferenceExpressionImpl)place, Object.class.getName());
            return;
        }
        GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)place.getProject());
        GradleResolverUtil.processDeclarations(psiManager, processor, state, place, "org.gradle.api.artifacts.dsl.ArtifactHandler");
        PsiClass contributorClass = psiManager.findClassWithCache("org.gradle.api.artifacts.dsl.ArtifactHandler", place.getResolveScope());
        if (contributorClass != null) {
            GradleArtifactsContributor.processAtrifactAddition(methodCallInfo.get(0), contributorClass, processor, state, place);
        }
    }

    private static void processAtrifactAddition(@NotNull String gradleConfigurationName, @NotNull PsiClass artifactHandlerClass, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiElement place) {
        if (gradleConfigurationName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/resolve/GradleArtifactsContributor", "processAtrifactAddition"));
        }
        if (artifactHandlerClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/resolve/GradleArtifactsContributor", "processAtrifactAddition"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/gradle/service/resolve/GradleArtifactsContributor", "processAtrifactAddition"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/gradle/service/resolve/GradleArtifactsContributor", "processAtrifactAddition"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/gradle/service/resolve/GradleArtifactsContributor", "processAtrifactAddition"));
        }
        GrLightMethodBuilder builder = new GrLightMethodBuilder(place.getManager(), gradleConfigurationName);
        PsiClassType type = PsiType.getJavaLangObject((PsiManager)place.getManager(), (GlobalSearchScope)place.getResolveScope());
        builder.addParameter((GrParameter)new GrLightParameter("artifactInfo", (PsiType)type, (PsiElement)builder));
        processor.execute((PsiElement)builder, state);
        GrMethodCall call = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethodCall.class);
        if (call == null) {
            return;
        }
        GrArgumentList args = call.getArgumentList();
        if (args == null) {
            return;
        }
        int argsCount = GradleResolverUtil.getGrMethodArumentsCount(args);
        ++argsCount;
        for (PsiMethod method : artifactHandlerClass.findMethodsByName("add", false)) {
            if (method.getParameterList().getParametersCount() != argsCount) continue;
            builder.setNavigationElement((PsiElement)method);
        }
    }
}

