/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.ide.util.newProjectWizard.AddModuleWizard;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.wizard.SelectExternalProjectStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.projectImport.ProjectOpenProcessorBase;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleProjectImportBuilder;
import org.jetbrains.plugins.gradle.service.project.wizard.GradleProjectImportProvider;
import org.jetbrains.plugins.gradle.service.settings.ImportFromGradleControl;

public class GradleProjectOpenProcessor
extends ProjectOpenProcessorBase<GradleProjectImportBuilder> {
    @NotNull
    public static final String[] BUILD_FILE_EXTENSIONS = new String[]{"gradle"};

    public GradleProjectOpenProcessor(@NotNull GradleProjectImportBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectOpenProcessor", "<init>"));
        }
        super((ProjectImportBuilder)builder);
    }

    @Nullable
    public String[] getSupportedExtensions() {
        return BUILD_FILE_EXTENSIONS;
    }

    public boolean canOpenProject(VirtualFile file) {
        if (!file.isDirectory()) {
            String fileName = file.getName();
            for (String extension : BUILD_FILE_EXTENSIONS) {
                if (!fileName.endsWith(extension)) continue;
                return true;
            }
        }
        return super.canOpenProject(file);
    }

    protected boolean doQuickImport(VirtualFile file, WizardContext wizardContext) {
        AddModuleWizard dialog = new AddModuleWizard(null, file.getPath(), new ProjectImportProvider[]{new GradleProjectImportProvider((GradleProjectImportBuilder)this.getBuilder())});
        ((GradleProjectImportBuilder)this.getBuilder()).prepare(wizardContext);
        ((ImportFromGradleControl)((GradleProjectImportBuilder)this.getBuilder()).getControl(null)).setLinkedProjectPath(file.getPath());
        dialog.getWizardContext().setProjectBuilder((ProjectBuilder)this.getBuilder());
        dialog.navigateToStep((Function)new Function<Step, Boolean>(){

            public Boolean fun(Step step) {
                return step instanceof SelectExternalProjectStep;
            }
        });
        boolean result = dialog.showAndGet();
        if (result && ((GradleProjectImportBuilder)this.getBuilder()).getExternalProjectNode() != null) {
            wizardContext.setProjectName(((ProjectData)((GradleProjectImportBuilder)this.getBuilder()).getExternalProjectNode().getData()).getInternalName());
        }
        return result;
    }

    public boolean lookForProjectsInDirectory() {
        return false;
    }
}

