/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.externalSystem.JavaProjectData;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalProjectImportBuilder;
import com.intellij.openapi.externalSystem.service.settings.AbstractImportFromExternalSystemControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import icons.GradleIcons;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.settings.ImportFromGradleControl;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectImportBuilder
extends AbstractExternalProjectImportBuilder<ImportFromGradleControl> {
    public GradleProjectImportBuilder(@NotNull ProjectDataManager dataManager) {
        if (dataManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectImportBuilder", "<init>"));
        }
        super(dataManager, (AbstractImportFromExternalSystemControl)new ImportFromGradleControl(), GradleConstants.SYSTEM_ID);
    }

    @NotNull
    public String getName() {
        String string = GradleBundle.message("gradle.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectImportBuilder", "getName"));
        }
        return string;
    }

    public Icon getIcon() {
        return GradleIcons.Gradle;
    }

    protected void doPrepare(@NotNull WizardContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectImportBuilder", "doPrepare"));
        }
        String pathToUse = this.getFileToImport();
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(pathToUse);
        if (file != null && file.isDirectory()) {
            pathToUse = new File(pathToUse, "build.gradle").getAbsolutePath();
        }
        ((ImportFromGradleControl)this.getControl(context.getProject())).setLinkedProjectPath(pathToUse);
    }

    protected void beforeCommit(@NotNull DataNode<ProjectData> dataNode, @NotNull Project project) {
        LanguageLevelProjectExtension languageLevelExtension;
        if (dataNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectImportBuilder", "beforeCommit"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectImportBuilder", "beforeCommit"));
        }
        if (!ExternalSystemApiUtil.isNewProjectConstruction()) {
            return;
        }
        DataNode javaProjectNode = ExternalSystemApiUtil.find(dataNode, (Key)JavaProjectData.KEY);
        if (javaProjectNode == null) {
            return;
        }
        LanguageLevel externalLanguageLevel = ((JavaProjectData)javaProjectNode.getData()).getLanguageLevel();
        if (externalLanguageLevel != (languageLevelExtension = LanguageLevelProjectExtension.getInstance((Project)project)).getLanguageLevel()) {
            languageLevelExtension.setLanguageLevel(externalLanguageLevel);
        }
    }

    protected void applyExtraSettings(@NotNull WizardContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectImportBuilder", "applyExtraSettings"));
        }
        DataNode node = this.getExternalProjectNode();
        if (node == null) {
            return;
        }
        DataNode javaProjectNode = ExternalSystemApiUtil.find((DataNode)node, (Key)JavaProjectData.KEY);
        if (javaProjectNode != null) {
            JavaProjectData data = (JavaProjectData)javaProjectNode.getData();
            context.setCompilerOutputDirectory(data.getCompileOutputPath());
            JavaSdkVersion version = data.getJdkVersion();
            Sdk jdk = GradleProjectImportBuilder.findJdk(version);
            if (jdk != null) {
                context.setProjectJdk(jdk);
            }
        }
    }

    @Nullable
    private static Sdk findJdk(@NotNull JavaSdkVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectImportBuilder", "findJdk"));
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        List javaSdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        Sdk candidate = null;
        for (Sdk sdk : javaSdks) {
            JavaSdkVersion v = javaSdk.getVersion(sdk);
            if (v == version) {
                return sdk;
            }
            if (candidate != null || v == null || !version.getMaxLanguageLevel().isAtLeast(version.getMaxLanguageLevel())) continue;
            candidate = sdk;
        }
        return candidate;
    }

    @NotNull
    protected File getExternalProjectConfigToUse(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectImportBuilder", "getExternalProjectConfigToUse"));
        }
        File file2 = file.isDirectory() ? file : file.getParentFile();
        if (file2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/wizard/GradleProjectImportBuilder", "getExternalProjectConfigToUse"));
        }
        return file2;
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == JavaSdk.getInstance();
    }
}

