/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemDebugEnvironment;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionExecuter;
import org.gradle.tooling.LongRunningOperation;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.remote.impl.GradleLibraryNamesMixer;
import org.jetbrains.plugins.gradle.service.project.BaseGradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.GradleExecutionHelper;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.ClassHolder;
import org.jetbrains.plugins.gradle.settings.GradleExecutionSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleEnvironment;

public class GradleProjectResolver
implements ExternalSystemProjectResolver<GradleExecutionSettings> {
    private static final Logger LOG = Logger.getInstance((String)("#" + GradleProjectResolver.class.getName()));
    @NotNull
    private final GradleExecutionHelper myHelper;
    private final GradleLibraryNamesMixer myLibraryNamesMixer;

    public GradleProjectResolver() {
        this(new GradleExecutionHelper());
    }

    public GradleProjectResolver(@NotNull GradleExecutionHelper helper) {
        if (helper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "<init>"));
        }
        this.myLibraryNamesMixer = new GradleLibraryNamesMixer();
        this.myHelper = helper;
    }

    @Nullable
    public DataNode<ProjectData> resolveProjectInfo(@NotNull ExternalSystemTaskId id, @NotNull String projectPath, boolean isPreviewMode, @Nullable GradleExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener) throws ExternalSystemException, IllegalArgumentException, IllegalStateException {
        GradleProjectResolverExtension projectResolverChain;
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "resolveProjectInfo"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "resolveProjectInfo"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "resolveProjectInfo"));
        }
        if (settings != null) {
            this.myHelper.ensureInstalledWrapper(id, projectPath, settings, listener);
            List<ClassHolder<? extends GradleProjectResolverExtension>> extensionClasses = settings.getResolverExtensions();
            ArrayDeque<GradleProjectResolverExtension> extensions = new ArrayDeque<GradleProjectResolverExtension>();
            for (ClassHolder<? extends GradleProjectResolverExtension> holder : extensionClasses) {
                GradleProjectResolverExtension extension;
                try {
                    extension = holder.getTargetClass().newInstance();
                }
                catch (Throwable e) {
                    throw new IllegalArgumentException(String.format("Can't instantiate project resolve extension for class '%s'", holder.getTargetClassName()), e);
                }
                GradleProjectResolverExtension previous = (GradleProjectResolverExtension)extensions.peekLast();
                if (previous != null) {
                    previous.setNext(extension);
                }
                extensions.add(extension);
            }
            projectResolverChain = (GradleProjectResolverExtension)extensions.peekFirst();
        } else {
            projectResolverChain = new BaseGradleProjectResolverExtension();
        }
        DataNode<ProjectData> resultProjectDataNode = this.myHelper.execute(projectPath, settings, new ProjectConnectionDataNodeFunction(id, projectPath, settings, listener, isPreviewMode, projectResolverChain, false));
        String buildSrcProjectPath = projectPath + "/buildSrc";
        this.handleBuildSrcProject(resultProjectDataNode, new ProjectConnectionDataNodeFunction(id, buildSrcProjectPath, settings, listener, isPreviewMode, projectResolverChain, true));
        return resultProjectDataNode;
    }

    public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "cancelTask"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "cancelTask"));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private DataNode<ProjectData> doResolveProjectInfo(@NotNull ProjectResolverContext resolverCtx, @NotNull GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) throws IllegalArgumentException, IllegalStateException {
        void var9_14;
        File file;
        if (resolverCtx == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "doResolveProjectInfo"));
        }
        if (projectResolverChain == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "doResolveProjectInfo"));
        }
        ProjectImportAction projectImportAction = new ProjectImportAction(resolverCtx.isPreviewMode());
        ArrayList<KeyValue<String, String>> extraJvmArgs = new ArrayList<KeyValue<String, String>>();
        ArrayList commandLineArgs = ContainerUtil.newArrayList();
        for (GradleProjectResolverExtension resolverExtension = projectResolverChain; resolverExtension != null; resolverExtension = resolverExtension.getNext()) {
            resolverExtension.setProjectResolverContext(resolverCtx);
            resolverExtension.preImportCheck();
            projectImportAction.addExtraProjectModelClasses(resolverExtension.getExtraProjectModelClasses());
            extraJvmArgs.addAll(resolverExtension.getExtraJvmArgs());
            commandLineArgs.addAll(resolverExtension.getExtraCommandLineArgs());
        }
        ParametersList parametersList = new ParametersList();
        for (KeyValue keyValue : extraJvmArgs) {
            parametersList.addProperty((String)keyValue.getKey(), (String)keyValue.getValue());
        }
        BuildActionExecuter buildActionExecutor = resolverCtx.getConnection().action((BuildAction)projectImportAction);
        if (!GradleEnvironment.DISABLE_ENHANCED_TOOLING_API && (file = GradleExecutionHelper.generateInitScript(isBuildSrcProject)) != null) {
            ContainerUtil.addAll((Collection)commandLineArgs, (Object[])new String[]{"--init-script", file.getAbsolutePath()});
        }
        GradleExecutionHelper.prepare((LongRunningOperation)buildActionExecutor, resolverCtx.getExternalSystemTaskId(), resolverCtx.getSettings(), resolverCtx.getListener(), parametersList.getParameters(), commandLineArgs, resolverCtx.getConnection());
        try {
            ProjectImportAction.AllModels allModels = (ProjectImportAction.AllModels)buildActionExecutor.run();
            if (allModels == null) {
                throw new IllegalStateException("Unable to get project model for the project: " + resolverCtx.getProjectPath());
            }
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            Class aClass = resolverCtx.isPreviewMode() ? BasicIdeaProject.class : IdeaProject.class;
            ModelBuilder<BasicIdeaProject> modelBuilder = this.myHelper.getModelBuilder(aClass, resolverCtx.getExternalSystemTaskId(), resolverCtx.getSettings(), resolverCtx.getConnection(), resolverCtx.getListener(), parametersList.getParameters());
            IdeaProject ideaProject = (IdeaProject)modelBuilder.get();
            ProjectImportAction.AllModels allModels = new ProjectImportAction.AllModels(ideaProject);
        }
        BuildEnvironment buildEnvironment = GradleProjectResolver.getBuildEnvironment(resolverCtx);
        var9_14.setBuildEnvironment(buildEnvironment);
        resolverCtx.setModels((ProjectImportAction.AllModels)var9_14);
        ProjectData projectData = projectResolverChain.createProject();
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        JavaProjectData javaProjectData = projectResolverChain.createJavaProjectData();
        projectDataNode.createChild(JavaProjectData.KEY, (Object)javaProjectData);
        IdeaProject ideaProject = resolverCtx.getModels().getIdeaProject();
        DomainObjectSet gradleModules = ideaProject.getModules();
        if (gradleModules == null || gradleModules.isEmpty()) {
            throw new IllegalStateException("No modules found for the target project: " + ideaProject);
        }
        HashMap moduleMap = ContainerUtilRt.newHashMap();
        for (IdeaModule gradleModule : gradleModules) {
            String moduleName;
            if (gradleModule == null) continue;
            if (ExternalSystemDebugEnvironment.DEBUG_ORPHAN_MODULES_PROCESSING) {
                LOG.info(String.format("Importing module data: %s", gradleModule));
            }
            if ((moduleName = gradleModule.getName()) == null) {
                throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
            }
            ModuleData moduleData = projectResolverChain.createModule(gradleModule, projectData);
            Pair previouslyParsedModule = (Pair)moduleMap.get(moduleName);
            if (previouslyParsedModule != null) {
                throw new IllegalStateException(String.format("Modules with duplicate name (%s) detected: '%s' and '%s'", moduleName, moduleData, previouslyParsedModule));
            }
            DataNode moduleDataNode = projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
            moduleMap.put(moduleName, new Pair((Object)moduleDataNode, (Object)gradleModule));
        }
        ArrayList allTasks = ContainerUtil.newArrayList();
        for (Pair pair : moduleMap.values()) {
            DataNode moduleDataNode = (DataNode)pair.first;
            IdeaModule ideaModule = (IdeaModule)pair.second;
            projectResolverChain.populateModuleExtraModels(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            projectResolverChain.populateModuleContentRoots(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            projectResolverChain.populateModuleCompileOutputSettings(ideaModule, (DataNode<ModuleData>)moduleDataNode);
            projectResolverChain.populateModuleDependencies(ideaModule, (DataNode<ModuleData>)moduleDataNode, (DataNode<ProjectData>)projectDataNode);
            if (isBuildSrcProject) continue;
            Collection<TaskData> moduleTasks = projectResolverChain.populateModuleTasks(ideaModule, (DataNode<ModuleData>)moduleDataNode, (DataNode<ProjectData>)projectDataNode);
            allTasks.addAll(moduleTasks);
        }
        Collection<TaskData> rootProjectTaskCandidates = projectResolverChain.filterRootProjectTasks(allTasks);
        HashSet rootProjectTaskCandidatesMap = ContainerUtilRt.newHashSet();
        for (TaskData taskData : rootProjectTaskCandidates) {
            rootProjectTaskCandidatesMap.add(Pair.create((Object)taskData.getName(), (Object)taskData.getDescription()));
        }
        for (Pair p : rootProjectTaskCandidatesMap) {
            projectDataNode.createChild(ProjectKeys.TASK, (Object)new TaskData(GradleConstants.SYSTEM_ID, (String)p.first, projectData.getLinkedExternalProjectPath(), (String)p.second));
        }
        Collection libraries = ExternalSystemApiUtil.getChildren((DataNode)projectDataNode, (Key)ProjectKeys.LIBRARY);
        this.myLibraryNamesMixer.mixNames(libraries);
        DataNode dataNode = projectDataNode;
        if (dataNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "doResolveProjectInfo"));
        }
        return dataNode;
    }

    @Nullable
    private static BuildEnvironment getBuildEnvironment(@NotNull ProjectResolverContext resolverCtx) {
        if (resolverCtx == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "getBuildEnvironment"));
        }
        try {
            return (BuildEnvironment)resolverCtx.getConnection().getModel(BuildEnvironment.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void handleBuildSrcProject(@NotNull DataNode<ProjectData> resultProjectDataNode, final @NotNull ProjectConnectionDataNodeFunction projectConnectionDataNodeFunction) {
        DataNode moduleDataNode;
        if (resultProjectDataNode == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "handleBuildSrcProject"));
        }
        if (projectConnectionDataNodeFunction == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver", "handleBuildSrcProject"));
        }
        if (projectConnectionDataNodeFunction.myIsPreviewMode || GradleEnvironment.DISABLE_ENHANCED_TOOLING_API || !new File(projectConnectionDataNodeFunction.myProjectPath).isDirectory()) {
            return;
        }
        DataNode buildSrcModuleDataNode = ExternalSystemApiUtil.find(resultProjectDataNode, (Key)ProjectKeys.MODULE, (BooleanFunction)new BooleanFunction<DataNode<ModuleData>>(){

            public boolean fun(DataNode<ModuleData> node) {
                return projectConnectionDataNodeFunction.myProjectPath.equals(((ModuleData)node.getData()).getLinkedExternalProjectPath());
            }
        });
        if (buildSrcModuleDataNode != null) {
            return;
        }
        DataNode<ProjectData> buildSrcProjectDataDataNode = this.myHelper.execute(projectConnectionDataNodeFunction.myProjectPath, projectConnectionDataNodeFunction.mySettings, projectConnectionDataNodeFunction);
        if (buildSrcProjectDataDataNode != null && (moduleDataNode = ExternalSystemApiUtil.find(buildSrcProjectDataDataNode, (Key)ProjectKeys.MODULE)) != null) {
            for (DataNode libraryDataNode : ExternalSystemApiUtil.findAll(buildSrcProjectDataDataNode, (Key)ProjectKeys.LIBRARY)) {
                resultProjectDataNode.createChild(libraryDataNode.getKey(), libraryDataNode.getData());
            }
            DataNode newModuleDataNode = resultProjectDataNode.createChild(ProjectKeys.MODULE, moduleDataNode.getData());
            for (DataNode node : moduleDataNode.getChildren()) {
                newModuleDataNode.createChild(node.getKey(), node.getData());
            }
        }
    }

    private class ProjectConnectionDataNodeFunction
    implements Function<ProjectConnection, DataNode<ProjectData>> {
        @NotNull
        private final ExternalSystemTaskId myId;
        @NotNull
        private final String myProjectPath;
        @Nullable
        private final GradleExecutionSettings mySettings;
        @NotNull
        private final ExternalSystemTaskNotificationListener myListener;
        private final boolean myIsPreviewMode;
        @NotNull
        private final GradleProjectResolverExtension myProjectResolverChain;
        private final boolean myIsBuildSrcProject;

        public ProjectConnectionDataNodeFunction(@NotNull ExternalSystemTaskId id, @Nullable String projectPath, @NotNull GradleExecutionSettings settings, ExternalSystemTaskNotificationListener listener, @NotNull boolean isPreviewMode, GradleProjectResolverExtension projectResolverChain, boolean isBuildSrcProject) {
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$ProjectConnectionDataNodeFunction", "<init>"));
            }
            if (projectPath == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$ProjectConnectionDataNodeFunction", "<init>"));
            }
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$ProjectConnectionDataNodeFunction", "<init>"));
            }
            if (projectResolverChain == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolver$ProjectConnectionDataNodeFunction", "<init>"));
            }
            this.myId = id;
            this.myProjectPath = projectPath;
            this.mySettings = settings;
            this.myListener = listener;
            this.myIsPreviewMode = isPreviewMode;
            this.myProjectResolverChain = projectResolverChain;
            this.myIsBuildSrcProject = isBuildSrcProject;
        }

        public DataNode<ProjectData> fun(ProjectConnection connection) {
            try {
                return GradleProjectResolver.this.doResolveProjectInfo(new ProjectResolverContext(this.myId, this.myProjectPath, this.mySettings, connection, this.myListener, this.myIsPreviewMode), this.myProjectResolverChain, this.myIsBuildSrcProject);
            }
            catch (RuntimeException e) {
                LOG.info("Gradle project resolve error", (Throwable)e);
                throw this.myProjectResolverChain.getUserFriendlyError(e, this.myProjectPath, null);
            }
        }
    }
}

