/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.LinkedHashSet;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.DistributionFactory;
import org.gradle.util.DistributionLocator;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.GradleUserHomeLookup;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.Install;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.gradle.wrapper.WrapperExecutor;

public class DistributionFactoryExt
extends DistributionFactory {
    private final File userHomeDir;

    public DistributionFactoryExt(File userHomeDir) {
        this.userHomeDir = userHomeDir;
    }

    public Distribution getWrappedDistribution(File propertiesFile) {
        WrapperExecutor wrapper = WrapperExecutor.forWrapperPropertiesFile((File)propertiesFile, (Appendable)System.out);
        if (wrapper.getDistribution() != null) {
            return new ZippedDistribution(wrapper.getConfiguration(), this.userHomeDir);
        }
        return this.getDownloadedDistribution(GradleVersion.current().getVersion());
    }

    private Distribution getDownloadedDistribution(String gradleVersion) {
        URI distUri = new DistributionLocator().getDistributionFor(GradleVersion.version((String)gradleVersion));
        return this.getDistribution(distUri);
    }

    private static class ZippedDistribution
    implements Distribution {
        private InstalledDistribution installedDistribution;
        private final WrapperConfiguration wrapperConfiguration;
        private final File myUserHomeDir;

        private ZippedDistribution(WrapperConfiguration wrapperConfiguration, File userHomeDir) {
            this.wrapperConfiguration = wrapperConfiguration;
            this.myUserHomeDir = userHomeDir;
        }

        public String getDisplayName() {
            return String.format("Gradle distribution '%s'", this.wrapperConfiguration.getDistribution());
        }

        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, File userHomeDir) {
            if (this.installedDistribution == null) {
                File installDir;
                try {
                    File realUserHomeDir = userHomeDir != null ? userHomeDir : (this.myUserHomeDir != null ? this.myUserHomeDir : GradleUserHomeLookup.gradleUserHome());
                    Install install = new Install((IDownload)new ProgressReportingDownload(progressLoggerFactory), new PathAssembler(realUserHomeDir));
                    installDir = install.createDist(this.wrapperConfiguration);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.getDisplayName()), e);
                }
                catch (Exception e) {
                    throw new GradleConnectionException(String.format("Could not install Gradle distribution from '%s'.", this.wrapperConfiguration.getDistribution()), (Throwable)e);
                }
                this.installedDistribution = new InstalledDistribution(installDir, this.getDisplayName(), this.getDisplayName());
            }
            return this.installedDistribution.getToolingImplementationClasspath(progressLoggerFactory, userHomeDir);
        }
    }

    private static class InstalledDistribution
    implements Distribution {
        private final File gradleHomeDir;
        private final String displayName;
        private final String locationDisplayName;

        public InstalledDistribution(File gradleHomeDir, String displayName, String locationDisplayName) {
            this.gradleHomeDir = gradleHomeDir;
            this.displayName = displayName;
            this.locationDisplayName = locationDisplayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClassPath getToolingImplementationClasspath(ProgressLoggerFactory progressLoggerFactory, File userHomeDir) {
            ProgressLogger progressLogger = progressLoggerFactory.newOperation(DistributionFactory.class);
            progressLogger.setDescription("Validate distribution");
            progressLogger.started();
            try {
                ClassPath classPath = this.getToolingImpl();
                return classPath;
            }
            finally {
                progressLogger.completed();
            }
        }

        private ClassPath getToolingImpl() {
            if (!this.gradleHomeDir.exists()) {
                throw new IllegalArgumentException(String.format("The specified %s does not exist.", this.locationDisplayName));
            }
            if (!this.gradleHomeDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s is not a directory.", this.locationDisplayName));
            }
            File libDir = new File(this.gradleHomeDir, "lib");
            if (!libDir.isDirectory()) {
                throw new IllegalArgumentException(String.format("The specified %s does not appear to contain a Gradle distribution.", this.locationDisplayName));
            }
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (File file : libDir.listFiles()) {
                if (!file.getName().endsWith(".jar")) continue;
                files.add(file);
            }
            return new DefaultClassPath(files);
        }
    }

    private static class ProgressReportingDownload
    implements IDownload {
        private final ProgressLoggerFactory progressLoggerFactory;

        private ProgressReportingDownload(ProgressLoggerFactory progressLoggerFactory) {
            this.progressLoggerFactory = progressLoggerFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void download(URI address, File destination) throws Exception {
            ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(DistributionFactory.class);
            progressLogger.setDescription(String.format("Download %s", address));
            progressLogger.started();
            try {
                new Download("Gradle Tooling API", GradleVersion.current().getVersion()).download(address, destination);
            }
            finally {
                progressLogger.completed();
            }
        }
    }
}

